/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.security.oauth;

import java.util.List;
import org.codegist.common.lang.State;
import org.codegist.crest.config.MethodType;
import org.codegist.crest.param.EncodedPair;
import org.codegist.crest.security.Authorization;
import org.codegist.crest.security.AuthorizationToken;
import org.codegist.crest.security.oauth.OAuthApi;
import org.codegist.crest.security.oauth.OAuthToken;
import org.codegist.crest.security.oauth.OAuthenticator;
import org.codegist.crest.util.Pairs;

public class OAuthorization
implements Authorization {
    private final OAuthenticator oauth;
    private final OAuthApi oauthApi;
    private volatile OAuthToken accessOAuthToken;

    public OAuthorization(OAuthToken accessOAuthToken, OAuthenticator oauth) {
        this(accessOAuthToken, oauth, null);
    }

    public OAuthorization(OAuthToken accessOAuthToken, OAuthenticator oauth, OAuthApi oauthApi) {
        this.oauth = oauth;
        this.oauthApi = oauthApi;
        this.accessOAuthToken = accessOAuthToken;
    }

    public AuthorizationToken authorize(MethodType methodType, String url, EncodedPair ... parameters) throws Exception {
        List<EncodedPair> oauthParams = this.oauth.oauth(this.accessOAuthToken, methodType, url, parameters);
        return new AuthorizationToken("OAuth", Pairs.join(oauthParams, ',', '=', false, true));
    }

    public void refresh() throws Exception {
        State.notNull(this.oauthApi, "AccessToken refresh impossible, you must specify the oauth_session_handle and refresh access token url, see CRestBuilder.", new Object[0]);
        this.accessOAuthToken = this.oauthApi.refreshAccessToken(this.accessOAuthToken);
    }
}

