/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.security.oauth;

import java.util.Collections;
import java.util.Map;
import org.codegist.common.lang.ToStringBuilder;
import org.codegist.crest.param.EncodedPair;
import org.codegist.crest.util.Pairs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthToken {
    private final String token;
    private final String secret;
    private final Map<String, String> attributes;

    public OAuthToken(String token, String secret) {
        this(token, secret, Collections.emptyMap());
    }

    public OAuthToken(String token, String secret, Map<String, String> attributes) {
        this.token = token;
        this.secret = secret;
        this.attributes = Collections.unmodifiableMap(attributes);
    }

    public String getToken() {
        return this.token;
    }

    public String getSecret() {
        return this.secret;
    }

    public EncodedPair getAttribute(String name) {
        if (this.attributes.containsKey(name)) {
            return Pairs.toPreEncodedPair(name, this.attributes.get(name));
        }
        return null;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return new ToStringBuilder(this).append("token", this.token).append("secret", this.secret).append("attributes", this.attributes).toString();
    }
}

