/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.security.handler;

import org.codegist.common.log.Logger;
import org.codegist.crest.CRestConfig;
import org.codegist.crest.handler.RetryHandler;
import org.codegist.crest.io.RequestException;
import org.codegist.crest.security.Authorization;

public class RefreshAuthorizationRetryHandler
implements RetryHandler {
    public static final String UNAUTHORIZED_STATUS_CODE_PROP = RefreshAuthorizationRetryHandler.class.getName() + "#unauthorized-status-code";
    private static final Logger LOGGER = Logger.getLogger(RefreshAuthorizationRetryHandler.class);
    private final Authorization authorization;
    private final int max;
    private final int unauthorizedStatusCode;

    public RefreshAuthorizationRetryHandler(CRestConfig crestConfig) {
        this.max = crestConfig.getMaxAttempts() + 1;
        this.unauthorizedStatusCode = (Integer)crestConfig.get(UNAUTHORIZED_STATUS_CODE_PROP);
        this.authorization = (Authorization)crestConfig.get(Authorization.class);
    }

    public boolean retry(RequestException exception, int attemptNumber) throws Exception {
        if (attemptNumber > this.max) {
            LOGGER.debug("Not retrying, maximum failure reached.");
            return false;
        }
        if (exception.hasResponse() && exception.getResponse().getStatusCode() == this.unauthorizedStatusCode) {
            LOGGER.debug("Unauthorized status code has been detected, refreshing authentification and retry.");
            this.authorization.refresh();
        }
        return true;
    }
}

