/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.param;

import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.codegist.crest.CRestException;
import org.codegist.crest.config.ParamType;
import org.codegist.crest.param.CollectionMergingCookieParamProcessor;
import org.codegist.crest.param.CollectionMergingParamProcessor;
import org.codegist.crest.param.DefaultCookieParamProcessor;
import org.codegist.crest.param.DefaultParamProcessor;
import org.codegist.crest.param.EncodedPair;
import org.codegist.crest.param.Param;
import org.codegist.crest.param.ParamProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParamProcessors {
    private ParamProcessors() {
        throw new IllegalStateException();
    }

    public static ParamProcessor newInstance(ParamType type, String listSeparator) {
        switch (type) {
            case COOKIE: {
                return listSeparator != null ? new CollectionMergingCookieParamProcessor(listSeparator) : DefaultCookieParamProcessor.INSTANCE;
            }
        }
        return listSeparator != null ? new CollectionMergingParamProcessor(listSeparator) : DefaultParamProcessor.INSTANCE;
    }

    public static Iterator<EncodedPair> iterate(List<Param> params, Charset charset) {
        return ParamProcessors.iterate(params, charset, true);
    }

    public static Iterator<EncodedPair> iterate(List<Param> params, Charset charset, boolean encodeIfNeeded) {
        return new ProcessIterator(params, charset, encodeIfNeeded);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ProcessIterator
    implements Iterator<EncodedPair> {
        private final Iterator<Param> params;
        private final Charset charset;
        private final boolean encodeIfNeeded;
        private Iterator<EncodedPair> current;

        private ProcessIterator(List<Param> params, Charset charset, boolean encodeIfNeeded) {
            this.params = params.iterator();
            this.charset = charset;
            this.encodeIfNeeded = encodeIfNeeded;
        }

        @Override
        public boolean hasNext() {
            if (this.current != null && this.current.hasNext()) {
                return true;
            }
            if (this.params.hasNext()) {
                this.doNext();
                return this.hasNext();
            }
            return false;
        }

        @Override
        public EncodedPair next() {
            return this.current.next();
        }

        private void doNext() {
            Param currentParam = this.params.next();
            try {
                this.current = currentParam.getParamConfig().getParamProcessor().process(currentParam, this.charset, this.encodeIfNeeded).iterator();
            }
            catch (Exception e) {
                throw CRestException.handle(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

