/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.param;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import org.codegist.crest.param.EncodedPair;
import org.codegist.crest.param.Param;
import org.codegist.crest.param.ParamProcessor;
import org.codegist.crest.serializer.Serializer;
import org.codegist.crest.util.Pairs;
import org.codegist.crest.util.Serializers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CollectionMergingParamProcessor
implements ParamProcessor {
    private final String listSeparator;

    public CollectionMergingParamProcessor(String listSeparator) {
        this.listSeparator = listSeparator;
    }

    @Override
    public List<EncodedPair> process(Param param, Charset charset, boolean encodeIfNeeded) throws Exception {
        StringBuilder sb = new StringBuilder();
        Serializer serializer = param.getParamConfig().getSerializer();
        boolean isEncoded = !encodeIfNeeded || param.getParamConfig().isEncoded();
        boolean first = true;
        for (Object value : param.getValue()) {
            String serializedValue = Serializers.serialize(serializer, value, charset);
            if (!first) {
                sb.append(this.listSeparator);
            }
            sb.append(serializedValue);
            first = false;
        }
        if (sb.length() == 0) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Pairs.toPair(param.getParamConfig().getName(), sb.toString(), charset, isEncoded));
    }
}

