/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.param;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import org.codegist.common.lang.Strings;
import org.codegist.crest.param.CollectionMergingParamProcessor;
import org.codegist.crest.param.EncodedPair;
import org.codegist.crest.param.Param;
import org.codegist.crest.util.Pairs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CollectionMergingCookieParamProcessor
extends CollectionMergingParamProcessor {
    public CollectionMergingCookieParamProcessor(String listSeparator) {
        super(listSeparator);
    }

    @Override
    public List<EncodedPair> process(Param param, Charset charset, boolean encodeIfNeeded) throws Exception {
        List<EncodedPair> pairs = super.process(param, charset, encodeIfNeeded);
        String cookie = Pairs.join(pairs, ',');
        if (Strings.isBlank(cookie)) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Pairs.toPreEncodedPair("Cookie", cookie));
    }
}

