/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.io.http;

import java.io.IOException;
import java.io.OutputStream;
import org.codegist.common.log.Logger;
import org.codegist.common.log.LoggingOutputStream;
import org.codegist.crest.CRestException;
import org.codegist.crest.io.Request;
import org.codegist.crest.io.http.HttpEntityWriter;

class RequestEntityWriter
implements HttpEntityWriter {
    private static final Logger LOGGER = Logger.getLogger(Request.class);
    private final Request request;

    RequestEntityWriter(Request request) {
        this.request = request;
    }

    public void writeEntityTo(OutputStream out) throws IOException {
        OutputStream os = !LOGGER.isTraceOn() ? out : new LoggingOutputStream(out, LOGGER);
        try {
            this.request.getMethodConfig().getEntityWriter().writeTo(this.request, os);
        }
        catch (Exception e) {
            throw CRestException.handle(e);
        }
        os.flush();
    }

    public int getContentLength() {
        return this.request.getMethodConfig().getEntityWriter().getContentLength(this.request);
    }
}

