/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.io.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import org.codegist.common.log.Logger;
import org.codegist.crest.config.MethodType;
import org.codegist.crest.io.http.HttpChannel;
import org.codegist.crest.io.http.HttpEntityWriter;

final class HttpURLConnectionHttpChannel
implements HttpChannel {
    private static final Logger LOG = Logger.getLogger(HttpURLConnectionHttpChannel.class);
    private final HttpURLConnection con;
    private final MethodType methodType;
    private HttpEntityWriter httpEntityWriter;

    public HttpURLConnectionHttpChannel(HttpURLConnection con, MethodType methodType) {
        this.methodType = methodType;
        this.con = con;
        this.con.setRequestProperty("Connection", "Keep-Alive");
        this.con.setRequestProperty("User-Agent", "CodeGist-CRest Agent");
    }

    public void setSocketTimeout(int timeout) throws IOException {
        this.con.setReadTimeout(timeout);
    }

    public void setConnectionTimeout(int timeout) throws IOException {
        this.con.setConnectTimeout(timeout);
    }

    public void setHeader(String name, String value) throws IOException {
        this.con.setRequestProperty(name, value);
    }

    public void addHeader(String name, String value) throws IOException {
        this.con.addRequestProperty(name, value);
    }

    public void setContentType(String value) throws IOException {
        this.setHeader("Content-Type", value);
    }

    public void setAccept(String value) throws IOException {
        this.setHeader("Accept", value);
    }

    public void writeEntityWith(HttpEntityWriter httpEntityWriter) throws IOException {
        this.httpEntityWriter = httpEntityWriter;
    }

    public HttpChannel.Response send() throws IOException {
        this.con.setAllowUserInteraction(true);
        if (this.methodType.hasEntity()) {
            if (this.httpEntityWriter.getContentLength() >= 0) {
                this.con.setRequestProperty("Content-Length", String.valueOf(this.httpEntityWriter.getContentLength()));
            }
            this.con.setDoOutput(true);
            OutputStream os = this.con.getOutputStream();
            this.httpEntityWriter.writeEntityTo(os);
            os.flush();
            os.close();
        }
        return new HttpURLResponse(this.con);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HttpURLResponse
    implements HttpChannel.Response {
        private final HttpURLConnection con;

        private HttpURLResponse(HttpURLConnection con) {
            this.con = con;
        }

        @Override
        public int getStatusCode() throws IOException {
            return this.con.getResponseCode();
        }

        @Override
        public String getStatusMessage() throws IOException {
            return this.con.getResponseMessage();
        }

        @Override
        public InputStream getEntity() throws IOException {
            if (this.getStatusCode() >= 400) {
                return this.con.getErrorStream();
            }
            return this.con.getInputStream();
        }

        @Override
        public String getHeaderField(String field) {
            return this.con.getHeaderField(field);
        }

        @Override
        public Map<String, List<String>> getHeaderFields() {
            return this.con.getHeaderFields();
        }

        @Override
        public String getContentType() {
            return this.con.getContentType();
        }

        @Override
        public String getContentEncoding() {
            return this.con.getContentEncoding();
        }

        @Override
        public void close() {
            LOG.trace("Disconnecting...");
            this.con.disconnect();
        }
    }
}

