/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.io.http;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.codegist.common.io.IOs;
import org.codegist.common.lang.Disposable;
import org.codegist.crest.io.Request;
import org.codegist.crest.io.Response;
import org.codegist.crest.io.http.DelegatingResponse;
import org.codegist.crest.io.http.HttpResource;
import org.codegist.crest.io.http.HttpResourceInputStream;
import org.codegist.crest.serializer.ResponseDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HttpResponse
implements Response,
Disposable {
    private final ResponseDeserializer baseResponseDeserializer;
    private final ResponseDeserializer customTypeResponseDeserializer;
    private final Request request;
    private final InputStream inputStream;
    private final HttpResource resource;

    public HttpResponse(ResponseDeserializer baseResponseDeserializer, ResponseDeserializer customTypeResponseDeserializer, Request request, HttpResource resource) throws IOException {
        this.baseResponseDeserializer = baseResponseDeserializer;
        this.customTypeResponseDeserializer = customTypeResponseDeserializer;
        this.request = request;
        this.resource = resource;
        this.inputStream = new HttpResourceInputStream(resource);
    }

    @Override
    public int getStatusCode() throws IOException {
        return this.resource.getStatusCode();
    }

    public String getStatusMessage() throws IOException {
        return this.resource.getStatusMessage();
    }

    @Override
    public String getContentType() throws IOException {
        return this.resource.getContentType();
    }

    @Override
    public Charset getCharset() throws IOException {
        return this.resource.getCharset();
    }

    @Override
    public String getContentEncoding() throws IOException {
        return this.resource.getContentEncoding();
    }

    @Override
    public String getHeaderField(String field) throws IOException {
        return this.resource.getHeaderField(field);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() throws IOException {
        return this.resource.getHeaderFields();
    }

    @Override
    public Type getExpectedGenericType() {
        return this.request.getMethodConfig().getMethod().getGenericReturnType();
    }

    @Override
    public Class<?> getExpectedType() {
        return this.request.getMethodConfig().getMethod().getReturnType();
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public InputStream asStream() {
        return this.inputStream;
    }

    @Override
    public <T> T deserialize() throws Exception {
        if (this.inputStream != null && this.resource.getEntity() != null) {
            return this.baseResponseDeserializer.deserialize(this);
        }
        return null;
    }

    @Override
    public <T> T to(Class<T> type) throws Exception {
        return this.to(type, type);
    }

    @Override
    public <T> T to(Class<T> type, Type genericType) throws Exception {
        if (this.inputStream != null && this.resource.getEntity() != null) {
            return this.customTypeResponseDeserializer.deserialize(new ExpectedTypeOverriderResponse(this, type, genericType));
        }
        return null;
    }

    @Override
    public void dispose() {
        IOs.close(this.inputStream);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ExpectedTypeOverriderResponse
    extends DelegatingResponse {
        private final Class<?> clazz;
        private final Type type;

        private ExpectedTypeOverriderResponse(Response delegate, Class<?> clazz, Type type) {
            super(delegate);
            this.clazz = clazz;
            this.type = type;
        }

        @Override
        public Type getExpectedGenericType() {
            return this.type;
        }

        @Override
        public Class<?> getExpectedType() {
            return this.clazz;
        }
    }
}

