/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.io.http;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.codegist.common.io.InputStreamWrapper;
import org.codegist.common.log.Logger;
import org.codegist.crest.io.http.HttpResource;

class HttpResourceInputStream
extends InputStreamWrapper {
    private static final Logger LOGGER = Logger.getLogger(HttpResourceInputStream.class);
    private final HttpResource resource;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public HttpResourceInputStream(HttpResource resource) throws IOException {
        super(resource.getEntity());
        this.resource = resource;
    }

    public void close() throws IOException {
        if (!this.closed.compareAndSet(false, true)) {
            LOGGER.trace("This http stream has already been closed, ignoring close request.");
            return;
        }
        try {
            LOGGER.debug("Releasing underlying network resources.");
            this.resource.close();
        }
        finally {
            try {
                super.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void finalize() throws Throwable {
        try {
            LOGGER.trace("Finalizing...");
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

