/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.io.http;

import java.nio.charset.Charset;
import java.util.Iterator;
import org.codegist.common.lang.Strings;
import org.codegist.crest.config.MethodConfig;
import org.codegist.crest.config.ParamType;
import org.codegist.crest.config.PathBuilder;
import org.codegist.crest.io.Request;
import org.codegist.crest.param.EncodedPair;
import org.codegist.crest.util.Pairs;

final class HttpRequests {
    private HttpRequests() {
        throw new IllegalStateException();
    }

    public static String toUrl(Request request) throws Exception {
        String matrix;
        MethodConfig mc = request.getMethodConfig();
        Charset charset = mc.getCharset();
        PathBuilder pathBuilder = mc.getPathTemplate().getBuilder(charset);
        Iterator<EncodedPair> pathParamsIterator = request.getEncodedParamsIterator(ParamType.PATH);
        while (pathParamsIterator.hasNext()) {
            EncodedPair encoded = pathParamsIterator.next();
            pathBuilder.merge(encoded.getName(), encoded.getValue(), true);
        }
        String query = Pairs.join(request.getEncodedParamsIterator(ParamType.QUERY), '&');
        if (Strings.isNotBlank(query)) {
            query = "?" + query;
        }
        if (Strings.isNotBlank(matrix = Pairs.join(request.getEncodedParamsIterator(ParamType.MATRIX), ';'))) {
            matrix = ";" + matrix;
        }
        return pathBuilder.build() + matrix + query;
    }
}

