/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.io.http;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.codegist.common.collect.Arrays;
import org.codegist.common.lang.Disposable;
import org.codegist.common.lang.Disposables;
import org.codegist.common.lang.Strings;
import org.codegist.common.log.Logger;
import org.codegist.crest.config.MethodConfig;
import org.codegist.crest.config.MethodType;
import org.codegist.crest.config.ParamType;
import org.codegist.crest.io.Request;
import org.codegist.crest.io.RequestException;
import org.codegist.crest.io.RequestExecutor;
import org.codegist.crest.io.Response;
import org.codegist.crest.io.http.HttpChannel;
import org.codegist.crest.io.http.HttpChannelFactory;
import org.codegist.crest.io.http.HttpChannelResponseHttpResource;
import org.codegist.crest.io.http.HttpRequests;
import org.codegist.crest.io.http.HttpResponse;
import org.codegist.crest.io.http.RequestEntityWriter;
import org.codegist.crest.param.EncodedPair;
import org.codegist.crest.serializer.ResponseDeserializer;

public class HttpRequestExecutor
implements RequestExecutor,
Disposable {
    private static final Logger LOGGER = Logger.getLogger(HttpRequestExecutor.class);
    private final HttpChannelFactory channelFactory;
    private final ResponseDeserializer baseResponseDeserializer;
    private final ResponseDeserializer customTypeResponseDeserializer;

    public HttpRequestExecutor(HttpChannelFactory channelFactory, ResponseDeserializer baseResponseDeserializer, ResponseDeserializer customTypeResponseDeserializer) {
        this.channelFactory = channelFactory;
        this.baseResponseDeserializer = baseResponseDeserializer;
        this.customTypeResponseDeserializer = customTypeResponseDeserializer;
    }

    public Response execute(Request request) throws Exception {
        try {
            return this.doExecute(request);
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
    }

    private HttpResponse doExecute(Request request) throws IOException, Exception {
        String[] consumes;
        String url = HttpRequests.toUrl(request);
        MethodConfig mc = request.getMethodConfig();
        Charset charset = mc.getCharset();
        LOGGER.debug("Initiating HTTP Channel: %s %s", new Object[]{mc.getType(), url});
        LOGGER.trace(request);
        MethodType methodType = mc.getType();
        HttpChannel httpChannel = this.channelFactory.open(methodType, url, charset);
        int coTimeout = mc.getConnectionTimeout();
        LOGGER.debug("Set Connection Timeout: %d ", coTimeout);
        httpChannel.setConnectionTimeout(coTimeout);
        int soTimeout = mc.getSocketTimeout();
        LOGGER.debug("Set Socket Timeout: %d ", soTimeout);
        httpChannel.setSocketTimeout(soTimeout);
        if (mc.getProduces() != null) {
            LOGGER.debug("Set Content-Type: %d ", mc.getProduces());
            httpChannel.setContentType(mc.getProduces());
        }
        if ((consumes = mc.getConsumes()).length > 0) {
            String accept = Arrays.join(",", consumes);
            LOGGER.debug("Set Accept: %d ", accept);
            httpChannel.setAccept(accept);
        }
        Iterator<EncodedPair> headers = request.getEncodedParamsIterator(ParamType.HEADER);
        while (headers.hasNext()) {
            EncodedPair encoded = headers.next();
            String name = encoded.getName();
            String value = encoded.getValue();
            LOGGER.debug("Header %s: %s ", name, value);
            httpChannel.addHeader(name, value);
        }
        Iterator<EncodedPair> cookies = request.getEncodedParamsIterator(ParamType.COOKIE);
        while (cookies.hasNext()) {
            EncodedPair encoded = cookies.next();
            String name = encoded.getName();
            String value = encoded.getValue();
            LOGGER.debug("%s: %s ", name, value);
            httpChannel.addHeader(name, value);
        }
        if (methodType.hasEntity()) {
            String contentType = mc.getEntityWriter().getContentType(request);
            if (Strings.isNotBlank(contentType)) {
                if (mc.getProduces() == null) {
                    LOGGER.debug("Entity Content-Type : %s", contentType);
                    httpChannel.setContentType(contentType);
                } else {
                    LOGGER.debug("Entity Content-Type : %s (ignored as previously set)", contentType);
                }
            }
            httpChannel.writeEntityWith(new RequestEntityWriter(request));
        }
        HttpChannel.Response response = httpChannel.send();
        return new HttpResponse(this.baseResponseDeserializer, this.customTypeResponseDeserializer, request, new HttpChannelResponseHttpResource(response));
    }

    public void dispose() {
        Disposables.dispose((Object)this.channelFactory);
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }
}

