/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.io.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.codegist.crest.config.MethodConfig;
import org.codegist.crest.config.ParamConfig;
import org.codegist.crest.io.RequestBuilder;
import org.codegist.crest.io.RequestBuilderFactory;
import org.codegist.crest.io.http.HttpRequest;
import org.codegist.crest.param.DefaultParam;
import org.codegist.crest.param.Param;

public class HttpRequestBuilderFactory
implements RequestBuilderFactory {
    public RequestBuilder create() {
        return new Builder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Builder
    implements RequestBuilder {
        private final List<Param> headerParams = new ArrayList<Param>();
        private final List<Param> matrixParams = new ArrayList<Param>();
        private final List<Param> queryParams = new ArrayList<Param>();
        private final List<Param> pathParams = new ArrayList<Param>();
        private final List<Param> cookieParams = new ArrayList<Param>();
        private final List<Param> formParams = new ArrayList<Param>();

        private Builder() {
        }

        @Override
        public HttpRequest build(MethodConfig methodConfig) {
            return new HttpRequest(methodConfig, this.headerParams, this.matrixParams, this.queryParams, this.pathParams, this.cookieParams, this.formParams);
        }

        @Override
        public Builder addParams(ParamConfig ... paramConfigs) {
            for (ParamConfig param : paramConfigs) {
                this.addParam(param);
            }
            return this;
        }

        @Override
        public Builder addParam(ParamConfig paramConfig) {
            return this.addParam(paramConfig, paramConfig.getDefaultValue());
        }

        @Override
        public Builder addParam(ParamConfig paramConfig, Object value) {
            return this.addParam(paramConfig, Collections.singleton(value));
        }

        @Override
        public Builder addParam(ParamConfig paramConfig, Collection<Object> values) {
            DefaultParam param = new DefaultParam(paramConfig, values);
            switch (paramConfig.getType()) {
                case COOKIE: {
                    this.cookieParams.add(param);
                    break;
                }
                case FORM: {
                    this.formParams.add(param);
                    break;
                }
                case HEADER: {
                    this.headerParams.add(param);
                    break;
                }
                case MATRIX: {
                    this.matrixParams.add(param);
                    break;
                }
                case PATH: {
                    this.pathParams.add(param);
                    break;
                }
                case QUERY: {
                    this.queryParams.add(param);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported param type ! (type=" + (Object)((Object)paramConfig.getType()) + ")");
                }
            }
            return this;
        }
    }
}

