/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.io.http;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.codegist.common.lang.ToStringBuilder;
import org.codegist.crest.config.MethodConfig;
import org.codegist.crest.config.ParamType;
import org.codegist.crest.io.Request;
import org.codegist.crest.param.EncodedPair;
import org.codegist.crest.param.Param;
import org.codegist.crest.param.ParamProcessors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HttpRequest
implements Request {
    private final MethodConfig methodConfig;
    private final List<Param> headerParams;
    private final List<Param> matrixParams;
    private final List<Param> queryParams;
    private final List<Param> pathParams;
    private final List<Param> cookieParams;
    private final List<Param> formParams;

    public HttpRequest(MethodConfig methodConfig, List<Param> headerParams, List<Param> matrixParams, List<Param> queryParams, List<Param> pathParams, List<Param> cookieParams, List<Param> formParams) {
        this.methodConfig = methodConfig;
        this.headerParams = Collections.unmodifiableList(headerParams);
        this.matrixParams = Collections.unmodifiableList(matrixParams);
        this.queryParams = Collections.unmodifiableList(queryParams);
        this.pathParams = Collections.unmodifiableList(pathParams);
        this.cookieParams = Collections.unmodifiableList(cookieParams);
        this.formParams = Collections.unmodifiableList(formParams);
    }

    @Override
    public MethodConfig getMethodConfig() {
        return this.methodConfig;
    }

    @Override
    public List<Param> getParams(ParamType type) {
        switch (type) {
            case COOKIE: {
                return this.cookieParams;
            }
            case FORM: {
                return this.formParams;
            }
            case HEADER: {
                return this.headerParams;
            }
            case MATRIX: {
                return this.matrixParams;
            }
            case PATH: {
                return this.pathParams;
            }
            case QUERY: {
                return this.queryParams;
            }
        }
        throw new IllegalArgumentException("Unsupported param type:" + (Object)((Object)type));
    }

    @Override
    public Iterator<EncodedPair> getEncodedParamsIterator(ParamType type) {
        return ParamProcessors.iterate(this.getParams(type), this.methodConfig.getCharset());
    }

    public String toString() {
        return new ToStringBuilder(this).append("methodConfig", this.methodConfig).append("headerParams", this.headerParams).append("matrixParams", this.matrixParams).append("queryParams", this.queryParams).append("pathParams", this.pathParams).append("cookieParams", this.cookieParams).append("formParams", this.formParams).toString();
    }
}

