/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.io.http;

import java.nio.charset.Charset;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.codegist.common.lang.Disposable;
import org.codegist.crest.CRestConfig;
import org.codegist.crest.config.MethodType;
import org.codegist.crest.io.http.HttpChannel;
import org.codegist.crest.io.http.HttpChannelFactory;
import org.codegist.crest.io.http.HttpClientFactory;
import org.codegist.crest.io.http.HttpClientHttpChannel;

public final class HttpClientHttpChannelFactory
implements HttpChannelFactory,
Disposable {
    public static final String HTTP_CLIENT_PROP = HttpClientHttpChannelFactory.class.getName() + "#user-http-client";
    private final HttpClient client;

    public HttpClientHttpChannelFactory(HttpClient client) {
        this.client = client;
    }

    public HttpClientHttpChannelFactory(CRestConfig crestConfig) {
        this(HttpClientFactory.create(crestConfig, HttpClientHttpChannelFactory.class));
    }

    public HttpChannel open(MethodType methodType, String url, Charset charset) {
        HttpGet request;
        switch (methodType) {
            case GET: {
                request = new HttpGet(url);
                break;
            }
            case POST: {
                request = new HttpPost(url);
                break;
            }
            case PUT: {
                request = new HttpPut(url);
                break;
            }
            case DELETE: {
                request = new HttpDelete(url);
                break;
            }
            case OPTIONS: {
                request = new HttpOptions(url);
                break;
            }
            case HEAD: {
                request = new HttpHead(url);
                break;
            }
            default: {
                throw new IllegalArgumentException("Method " + (Object)((Object)methodType) + " not supported");
            }
        }
        HttpProtocolParams.setContentCharset((HttpParams)request.getParams(), (String)charset.displayName());
        return new HttpClientHttpChannel(this.client, (HttpUriRequest)request);
    }

    public void dispose() {
        this.client.getConnectionManager().shutdown();
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }
}

