/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.io.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.codegist.common.io.EmptyInputStream;
import org.codegist.common.log.Logger;
import org.codegist.crest.io.http.HttpChannel;
import org.codegist.crest.io.http.HttpEntityWriter;

final class HttpClientHttpChannel
implements HttpChannel {
    private static final Logger LOGGER = Logger.getLogger(HttpClientHttpChannel.class);
    private final HttpClient client;
    private final HttpUriRequest request;

    public HttpClientHttpChannel(HttpClient client, HttpUriRequest request) {
        this.request = request;
        this.client = client;
    }

    public void setConnectionTimeout(int timeout) throws IOException {
        HttpConnectionParams.setConnectionTimeout((HttpParams)this.request.getParams(), (int)timeout);
    }

    public void setSocketTimeout(int timeout) throws IOException {
        HttpConnectionParams.setSoTimeout((HttpParams)this.request.getParams(), (int)timeout);
    }

    public void setHeader(String name, String value) throws IOException {
        this.request.setHeader(name, value);
    }

    public void addHeader(String name, String value) throws IOException {
        this.request.addHeader(name, value);
    }

    public void setContentType(String value) throws IOException {
        this.setHeader("Content-Type", value);
    }

    public void setAccept(String value) throws IOException {
        this.setHeader("Accept", value);
    }

    public void writeEntityWith(HttpEntityWriter httpEntityWriter) throws IOException {
        ((HttpEntityEnclosingRequest)this.request).setEntity((HttpEntity)new HttpEntityWriterHttpEntity(httpEntityWriter));
    }

    public HttpChannel.Response send() throws IOException {
        return new HttpClientResponse(this.request, this.client.execute(this.request));
    }

    private static final class HttpEntityWriterHttpEntity
    extends AbstractHttpEntity {
        private final HttpEntityWriter writer;

        private HttpEntityWriterHttpEntity(HttpEntityWriter writer) {
            this.writer = writer;
        }

        public boolean isRepeatable() {
            return false;
        }

        public long getContentLength() {
            return this.writer.getContentLength();
        }

        public InputStream getContent() throws IOException {
            throw new UnsupportedOperationException();
        }

        public void writeTo(OutputStream outstream) throws IOException {
            this.writer.writeEntityTo(outstream);
        }

        public boolean isStreaming() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HttpClientResponse
    implements HttpChannel.Response {
        private final HttpUriRequest request;
        private final HttpResponse response;

        private HttpClientResponse(HttpUriRequest request, HttpResponse response) {
            this.request = request;
            this.response = response;
        }

        @Override
        public InputStream getEntity() throws IOException {
            HttpEntity entity = this.response.getEntity();
            return entity != null ? entity.getContent() : EmptyInputStream.INSTANCE;
        }

        @Override
        public String getContentType() {
            Header header = this.response.getFirstHeader("Content-Type");
            if (header != null) {
                return header.getValue();
            }
            return null;
        }

        @Override
        public String getContentEncoding() {
            Header header = this.response.getFirstHeader("Content-Encoding");
            if (header != null) {
                return header.getValue();
            }
            return null;
        }

        @Override
        public int getStatusCode() throws IOException {
            return this.response.getStatusLine().getStatusCode();
        }

        @Override
        public String getHeaderField(String field) throws IOException {
            return this.response.getHeaders(field)[0].getName();
        }

        @Override
        public Map<String, List<String>> getHeaderFields() throws IOException {
            Header[] header;
            HashMap<String, List<String>> headerFields = new HashMap<String, List<String>>();
            for (Header aHeader : header = this.response.getAllHeaders()) {
                ArrayList<String> values = new ArrayList<String>();
                values.add(aHeader.getValue());
                headerFields.put(aHeader.getName(), values);
            }
            return headerFields;
        }

        @Override
        public String getStatusMessage() throws IOException {
            return this.response.getStatusLine().getReasonPhrase();
        }

        @Override
        public void close() {
            try {
                if (this.response != null && this.response.getEntity() != null) {
                    LOGGER.trace("Consuming Response Content...");
                    this.response.getEntity().consumeContent();
                }
            }
            catch (IOException e) {
                LOGGER.warn(e, "Failed to consume content for request %s", this.request);
            }
            finally {
                LOGGER.trace("Abording Request...");
                this.request.abort();
            }
        }
    }
}

