/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.io.http;

import java.net.ProxySelector;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.codegist.crest.CRestConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HttpClientFactory {
    static final String HTTP_CLIENT = "#user-http-client";
    private static final int HTTP_PORT = 80;
    private static final int HTTPS_PORT = 443;

    private HttpClientFactory() {
        throw new IllegalStateException();
    }

    public static HttpClient create(CRestConfig crestConfig, Class<?> source) {
        HttpClient httpClient = (HttpClient)crestConfig.get(source.getName() + HTTP_CLIENT);
        if (httpClient != null) {
            return httpClient;
        }
        int concurrencyLevel = crestConfig.getConcurrencyLevel();
        if (concurrencyLevel > 1) {
            BasicHttpParams params = new BasicHttpParams();
            HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
            ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)new ConnPerRouteBean(concurrencyLevel));
            ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)concurrencyLevel);
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
            schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
            ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
            httpClient = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)params);
        } else {
            httpClient = new DefaultHttpClient();
        }
        ((DefaultHttpClient)httpClient).setRoutePlanner((HttpRoutePlanner)new ProxySelectorRoutePlanner(httpClient.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault()));
        return httpClient;
    }
}

