/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.io.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.codegist.common.io.IOs;
import org.codegist.common.log.Logger;
import org.codegist.crest.io.Response;
import org.codegist.crest.io.http.HttpChannel;
import org.codegist.crest.io.http.HttpResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HttpChannelResponseHttpResource
implements HttpResource {
    private static final Logger RESPONSE_LOGGER = Logger.getLogger(Response.class);
    private final HttpChannel.Response response;
    private final InputStream inputStream;
    private final String contentEncoding;
    private final Charset charset;
    private final String contentType;
    private final Map<String, List<String>> headerFields;

    HttpChannelResponseHttpResource(HttpChannel.Response response) throws IOException {
        this.response = response;
        ContentType ct = new ContentType(response.getContentType());
        this.contentType = ct.mimeType;
        this.headerFields = response.getHeaderFields();
        this.charset = ct.charset;
        this.contentEncoding = response.getContentEncoding();
        this.inputStream = HttpChannelResponseHttpResource.getEntity(response, this.charset);
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public String getHeaderField(String field) throws IOException {
        StringBuilder header = new StringBuilder();
        for (String headerValue : this.headerFields.get(field)) {
            try {
                header.append(headerValue).append("\n");
            }
            catch (NoSuchElementException e) {
                e.printStackTrace();
            }
        }
        return String.valueOf(header);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.headerFields;
    }

    @Override
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public InputStream getEntity() throws IOException {
        return this.inputStream;
    }

    @Override
    public String getStatusMessage() throws IOException {
        return this.response.getStatusMessage();
    }

    @Override
    public int getStatusCode() throws IOException {
        return this.response.getStatusCode();
    }

    @Override
    public void close() throws IOException {
        this.response.close();
    }

    private static InputStream getEntity(HttpChannel.Response response, Charset charset) throws IOException {
        InputStream stream;
        InputStream inputStream = stream = "gzip".equals(response.getContentEncoding()) ? new GZIPInputStream(response.getEntity()) : response.getEntity();
        if (!RESPONSE_LOGGER.isTraceOn()) {
            return stream;
        }
        byte[] dump = IOs.toByteArray(stream, true);
        RESPONSE_LOGGER.trace("Received Http Response");
        RESPONSE_LOGGER.trace(new String(dump, charset));
        return new ByteArrayInputStream(dump);
    }

    private static final class ContentType {
        public static final Pattern SEMICOLON = Pattern.compile(";");
        public static final Pattern EQUAL = Pattern.compile("=");
        private static final String DEFAULT_MIME_TYPE = "text/html";
        private static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");
        private final String mimeType;
        private final Charset charset;

        private ContentType(String contentType) {
            String pMimeType = DEFAULT_MIME_TYPE;
            Charset pCharset = DEFAULT_CHARSET;
            if (contentType != null) {
                String[] contentTypes = SEMICOLON.split(contentType);
                if (contentTypes.length >= 1) {
                    pMimeType = contentTypes[0];
                }
                if (contentTypes.length >= 2 && contentTypes[1].contains("charset")) {
                    pCharset = Charset.forName(EQUAL.split(contentTypes[1])[1]);
                }
            }
            this.mimeType = pMimeType;
            this.charset = pCharset;
        }
    }
}

