/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.io.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.codegist.common.collect.Arrays;
import org.codegist.common.io.IOs;
import org.codegist.common.net.Urls;
import org.codegist.crest.CRestException;
import org.codegist.crest.config.MethodType;
import org.codegist.crest.io.http.EntityParamExtractor;
import org.codegist.crest.io.http.HttpChannel;
import org.codegist.crest.io.http.HttpEntityWriter;
import org.codegist.crest.param.EncodedPair;
import org.codegist.crest.security.Authorization;
import org.codegist.crest.security.AuthorizationToken;
import org.codegist.crest.util.Pairs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AuthorizationHttpChannel
implements HttpChannel {
    private static final Pattern SEMICOLON = Pattern.compile(";");
    private final Authorization authorization;
    private final Map<String, EntityParamExtractor> entityParamExtrators;
    private final HttpChannel delegate;
    private final List<EncodedPair> parameters = new ArrayList<EncodedPair>();
    private final String url;
    private final Charset charset;
    private final MethodType methodType;
    private String contentType = null;
    private String fullContentType = null;
    private HttpEntityWriter httpEntityWriter = null;

    public AuthorizationHttpChannel(HttpChannel delegate, Authorization authorization, MethodType methodType, String url, Charset charset, Map<String, EntityParamExtractor> entityParamExtrators) {
        this.url = url;
        this.methodType = methodType;
        this.charset = charset;
        this.delegate = delegate;
        this.entityParamExtrators = entityParamExtrators;
        this.authorization = authorization;
        String queryString = Urls.getQueryString(url);
        if (queryString != null) {
            this.parameters.addAll(Pairs.fromUrlEncoded(queryString));
        }
    }

    @Override
    public HttpChannel.Response send() throws IOException {
        if (this.hasEntityParamExtrator()) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.httpEntityWriter.writeEntityTo(out);
            List<EncodedPair> entityParams = this.entityParamExtrators.get(this.contentType).extract(this.fullContentType, this.charset, new ByteArrayInputStream(out.toByteArray()));
            this.parameters.addAll(entityParams);
        }
        this.authenticate();
        return this.delegate.send();
    }

    private void authenticate() throws IOException {
        AuthorizationToken token;
        try {
            token = this.authorization.authorize(this.methodType, this.url, Arrays.arrify(this.parameters, EncodedPair.class));
        }
        catch (Exception e) {
            throw CRestException.handle(e);
        }
        this.delegate.setHeader("Authorization", token.getName() + " " + token.getValue());
    }

    @Override
    public void setContentType(String contentType) throws IOException {
        this.delegate.setContentType(contentType);
        this.contentType = SEMICOLON.split(contentType)[0].trim();
        this.fullContentType = contentType;
    }

    @Override
    public void writeEntityWith(HttpEntityWriter httpEntityWriter) throws IOException {
        this.httpEntityWriter = this.hasEntityParamExtrator() ? new RewritableHttpEntityWriter(httpEntityWriter) : httpEntityWriter;
        this.delegate.writeEntityWith(this.httpEntityWriter);
    }

    @Override
    public void addHeader(String name, String value) throws IOException {
        this.delegate.addHeader(name, value);
    }

    @Override
    public void setHeader(String name, String value) throws IOException {
        this.delegate.setHeader(name, value);
    }

    @Override
    public void setAccept(String value) throws IOException {
        this.delegate.setAccept(value);
    }

    @Override
    public void setSocketTimeout(int timeout) throws IOException {
        this.delegate.setSocketTimeout(timeout);
    }

    @Override
    public void setConnectionTimeout(int timeout) throws IOException {
        this.delegate.setConnectionTimeout(timeout);
    }

    private boolean hasEntityParamExtrator() {
        return this.entityParamExtrators.containsKey(this.contentType);
    }

    private static final class RewritableHttpEntityWriter
    implements HttpEntityWriter {
        private final HttpEntityWriter delegate;
        private Integer contentLength;
        private byte[] entityContent;

        private RewritableHttpEntityWriter(HttpEntityWriter delegate) {
            this.delegate = delegate;
        }

        public void writeEntityTo(OutputStream out) throws IOException {
            if (this.entityContent == null) {
                ByteArrayOutputStream cache = new ByteArrayOutputStream();
                this.delegate.writeEntityTo(cache);
                this.entityContent = cache.toByteArray();
            }
            IOs.copy(new ByteArrayInputStream(this.entityContent), out);
        }

        public int getContentLength() {
            if (this.contentLength == null) {
                this.contentLength = this.delegate.getContentLength();
            }
            return this.contentLength;
        }
    }
}

