/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.io;

import org.codegist.common.lang.Disposables;
import org.codegist.crest.handler.RetryHandler;
import org.codegist.crest.io.Request;
import org.codegist.crest.io.RequestException;
import org.codegist.crest.io.RequestExecutor;
import org.codegist.crest.io.Response;

public class RetryingRequestExecutor
implements RequestExecutor {
    private final RequestExecutor delegate;
    private final int minErrorStatusCode;

    public RetryingRequestExecutor(RequestExecutor delegate, int minErrorStatusCode) {
        this.delegate = delegate;
        this.minErrorStatusCode = minErrorStatusCode;
    }

    public Response execute(Request request) throws Exception {
        Response response;
        RetryHandler retryHandler = request.getMethodConfig().getRetryHandler();
        RequestException exception = null;
        int attemptCount = 1;
        do {
            Disposables.dispose(exception);
            response = null;
            try {
                response = this.delegate.execute(request);
                if (response.getStatusCode() < this.minErrorStatusCode) {
                    return response;
                }
                exception = new RequestException("Request failed - status code: " + response.getStatusCode(), response);
            }
            catch (RequestException e) {
                exception = e;
            }
        } while (retryHandler.retry(exception, ++attemptCount));
        if (response != null) {
            return response;
        }
        throw exception;
    }
}

