/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.handler;

import org.codegist.common.log.Logger;
import org.codegist.crest.CRestConfig;
import org.codegist.crest.handler.RetryHandler;
import org.codegist.crest.io.RequestException;

public class MaxAttemptRetryHandler
implements RetryHandler {
    private final int max;
    private static final Logger LOG = Logger.getLogger(MaxAttemptRetryHandler.class);

    public MaxAttemptRetryHandler(CRestConfig crestConfig) {
        this.max = crestConfig.getMaxAttempts();
    }

    public boolean retry(RequestException exception, int attemptNumber) throws Exception {
        boolean retry = attemptNumber <= this.max;
        LOG.debug("Retrying attempt=%d,max=%d,retry=%b,reason=%s", attemptNumber, this.max, retry, exception != null ? exception.getMessage() : "unknown");
        return retry;
    }
}

