/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.entity.multipart;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.codegist.common.lang.Strings;
import org.codegist.crest.config.ParamConfig;
import org.codegist.crest.entity.multipart.MultiPart;
import org.codegist.crest.param.EncodedPair;
import org.codegist.crest.param.Param;
import org.codegist.crest.serializer.Serializer;
import org.codegist.crest.util.MultiParts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MultiPartTextSerializer
implements Serializer<MultiPart<Param>> {
    private static final String LRLN = "\r\n";
    static final MultiPartTextSerializer INSTANCE = new MultiPartTextSerializer();

    MultiPartTextSerializer() {
    }

    @Override
    public void serialize(MultiPart<Param> multipart, Charset charset, OutputStream outputStream) throws Exception {
        ParamConfig pc = multipart.getParamConfig();
        String partContentType = MultiParts.getContentType(pc);
        String partFileName = MultiParts.getFileName(pc);
        StringBuilder multiPartHeaderSb = new StringBuilder().append("--").append(multipart.getBoundary()).append(LRLN).append("Content-Disposition: form-data; name=\"").append(pc.getName()).append("\"");
        if (Strings.isNotBlank(partFileName)) {
            multiPartHeaderSb.append("; filename=\"").append(partFileName).append("\"");
        }
        multiPartHeaderSb.append(LRLN).append("Content-Type: ").append(Strings.defaultIfBlank(partContentType, "text/plain")).append("; charset=").append(charset.displayName()).append(LRLN).append(LRLN);
        String multiPartHeader = multiPartHeaderSb.toString();
        DataOutputStream out = new DataOutputStream(outputStream);
        for (EncodedPair pair : pc.getParamProcessor().process(multipart.getValue(), charset, false)) {
            out.writeBytes(multiPartHeader);
            out.write(pair.getValue().getBytes(charset));
            out.writeBytes(LRLN);
        }
    }
}

