/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.entity.multipart;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.codegist.common.lang.Strings;
import org.codegist.crest.config.ParamConfig;
import org.codegist.crest.entity.multipart.MultiPart;
import org.codegist.crest.serializer.Serializer;
import org.codegist.crest.util.MultiParts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MultiPartOctetStreamSerializer<T>
implements Serializer<MultiPart<T>> {
    private static final String LRLN = "\r\n";

    MultiPartOctetStreamSerializer() {
    }

    abstract String getFileName(MultiPart<T> var1);

    String getContentType(MultiPart<T> multipart) {
        return Strings.defaultIfBlank(MultiParts.getContentType(multipart.getParamConfig()), "application/octet-stream");
    }

    @Override
    public void serialize(MultiPart<T> multipart, Charset charset, OutputStream outputStream) throws Exception {
        ParamConfig pc = multipart.getParamConfig();
        String fileName = this.getFileName(multipart);
        String contentType = this.getContentType(multipart);
        StringBuilder headerSb = new StringBuilder().append("--").append(multipart.getBoundary()).append(LRLN).append("Content-Disposition: form-data; name=\"").append(pc.getName()).append("\"");
        if (Strings.isNotBlank(fileName)) {
            fileName = URLEncoder.encode(fileName, "UTF-8");
            headerSb.append("; filename=\"").append(fileName).append("\"");
        }
        headerSb.append(LRLN).append("Content-Type: ").append(contentType).append(LRLN).append(LRLN);
        DataOutputStream out = new DataOutputStream(outputStream);
        out.writeBytes(headerSb.toString());
        pc.getSerializer().serialize(multipart.getValue(), charset, out);
        out.writeBytes(LRLN);
    }
}

