/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.entity.multipart;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.codegist.common.lang.Randoms;
import org.codegist.crest.config.ParamConfig;
import org.codegist.crest.config.ParamType;
import org.codegist.crest.entity.EntityWriter;
import org.codegist.crest.entity.multipart.MultiPart;
import org.codegist.crest.entity.multipart.MultiPartBinarySerializer;
import org.codegist.crest.entity.multipart.MultiPartTextSerializer;
import org.codegist.crest.io.Request;
import org.codegist.crest.param.Param;
import org.codegist.crest.serializer.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPartEntityWriter
implements EntityWriter {
    private static final String MULTIPART = "multipart/form-data; boundary=";
    private static final String BOUNDARY = Randoms.randomAlphaNumeric(24);
    private static final String FULL_BOUNDARY = "--" + BOUNDARY;
    private static final String LRLN = "\r\n";
    private final Serializer<MultiPart<Param>> binarySerializer;
    private final Serializer<MultiPart<Param>> textSerializer;

    public MultiPartEntityWriter() {
        this(MultiPartBinarySerializer.INSTANCE, MultiPartTextSerializer.INSTANCE);
    }

    MultiPartEntityWriter(Serializer<MultiPart<Param>> binarySerializer, Serializer<MultiPart<Param>> textSerializer) {
        this.binarySerializer = binarySerializer;
        this.textSerializer = textSerializer;
    }

    @Override
    public String getContentType(Request request) {
        return MULTIPART + BOUNDARY;
    }

    @Override
    public int getContentLength(Request request) {
        return -1;
    }

    @Override
    public void writeTo(Request request, OutputStream outputStream) throws Exception {
        DataOutputStream out = new DataOutputStream(outputStream);
        List<Param> formParams = request.getParams(ParamType.FORM);
        Charset charset = request.getMethodConfig().getCharset();
        for (Param param : formParams) {
            ParamConfig pc = param.getParamConfig();
            Class<?> paramClass = pc.getValueClass();
            MultiPart<Param> multiPart = new MultiPart<Param>(pc, param, BOUNDARY);
            if (MultiPartBinarySerializer.isBinary(paramClass)) {
                this.binarySerializer.serialize(multiPart, charset, out);
                continue;
            }
            this.textSerializer.serialize(multiPart, charset, out);
        }
        out.writeBytes(FULL_BOUNDARY + "--" + LRLN);
        out.writeBytes(LRLN);
        out.flush();
    }
}

