/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.entity.multipart;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codegist.crest.config.ParamConfig;
import org.codegist.crest.entity.multipart.MultiPart;
import org.codegist.crest.entity.multipart.MultiPartFileSerializer;
import org.codegist.crest.entity.multipart.MultiPartInputStreamSerializer;
import org.codegist.crest.entity.multipart.MultiPartOctetStreamSerializer;
import org.codegist.crest.param.Param;
import org.codegist.crest.serializer.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MultiPartBinarySerializer
implements Serializer<MultiPart<Param>> {
    static final MultiPartBinarySerializer INSTANCE = new MultiPartBinarySerializer();
    private static final Map<Class, Serializer> BINARY_SERIALIZERS;

    MultiPartBinarySerializer() {
    }

    @Override
    public void serialize(MultiPart<Param> multipart, Charset charset, OutputStream out) throws Exception {
        Serializer<MultiPart<?>> serializer = MultiPartBinarySerializer.getSerializer(multipart.getParamConfig().getValueClass());
        MultiPartBinarySerializer.serialize(multipart, charset, out, serializer);
    }

    static Serializer<MultiPart<?>> getSerializer(Class<?> clazz) {
        return BINARY_SERIALIZERS.get(clazz);
    }

    static void serialize(MultiPart<Param> multipart, Charset charset, OutputStream out, Serializer<MultiPart<?>> serializer) throws Exception {
        ParamConfig pc = multipart.getParamConfig();
        String boundary = multipart.getBoundary();
        for (Object value : multipart.getValue().getValue()) {
            MultiPart<Object> valueMultiPart = new MultiPart<Object>(pc, value, boundary);
            serializer.serialize(valueMultiPart, charset, out);
        }
    }

    static boolean isBinary(Class<?> paramClass) {
        return BINARY_SERIALIZERS.containsKey(paramClass);
    }

    static {
        HashMap<Class, MultiPartOctetStreamSerializer> map = new HashMap<Class, MultiPartOctetStreamSerializer>();
        map.put(File.class, MultiPartFileSerializer.INSTANCE);
        map.put(InputStream.class, MultiPartInputStreamSerializer.INSTANCE);
        BINARY_SERIALIZERS = Collections.unmodifiableMap(map);
    }
}

