/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.config;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.codegist.common.lang.State;
import org.codegist.common.lang.Validate;
import org.codegist.common.net.Urls;
import org.codegist.crest.config.PathBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RegexPathTemplate
implements org.codegist.crest.config.PathTemplate {
    private static final Pattern TEMPLATE_NAME_PATTERN = Pattern.compile("^\\w[-\\w\\.]+$");
    private static final Pattern DEFAULT_VALIDATION_PATTERN = Pattern.compile("^[^/]+$");
    private final String urlTemplate;
    private final Map<String, PathTemplate> templates;

    private RegexPathTemplate(String urlTemplate, Map<String, PathTemplate> templates) {
        this.urlTemplate = urlTemplate;
        this.templates = templates;
    }

    @Override
    public PathBuilder getBuilder(Charset charset) {
        return new DefaultPathBuilder(charset);
    }

    public static RegexPathTemplate create(String urlTemplate) {
        StringBuffer baseUrl = new StringBuffer();
        HashMap<String, PathTemplate> templates = new HashMap<String, PathTemplate>();
        CurlyBraceTokenizer t = new CurlyBraceTokenizer(urlTemplate);
        while (t.hasNext()) {
            String tok = t.next();
            if (CurlyBraceTokenizer.insideBraces(tok)) {
                Pattern validationPattern;
                String name;
                int index = (tok = CurlyBraceTokenizer.stripBraces(tok)).indexOf(58);
                if (index > -1) {
                    name = tok.substring(0, index);
                    validationPattern = Pattern.compile("^" + tok.substring(index + 1) + "$");
                } else {
                    name = tok;
                    validationPattern = DEFAULT_VALIDATION_PATTERN;
                }
                Validate.isTrue(TEMPLATE_NAME_PATTERN.matcher(name).matches(), "Template name '%s' doesn't match the expected format: %s", name, TEMPLATE_NAME_PATTERN);
                Validate.isFalse(templates.containsKey(name), "Template name '%s' is already defined!", name);
                templates.put(name, new PathTemplate(name, validationPattern));
                baseUrl.append("{").append(name).append("}");
                continue;
            }
            baseUrl.append(tok);
        }
        String url = baseUrl.toString();
        Validate.isTrue(!Urls.hasQueryString(url), "Given url contains a query string: %s", url);
        return new RegexPathTemplate(url, templates);
    }

    private static final class CurlyBraceTokenizer {
        private List<String> tokens = new ArrayList<String>();
        private int tokenIdx;

        public CurlyBraceTokenizer(String string) {
            int idx;
            boolean outside = true;
            int level = 0;
            int lastIdx = 0;
            for (idx = 0; idx < string.length(); ++idx) {
                if (string.charAt(idx) == '{') {
                    if (outside) {
                        if (lastIdx < idx) {
                            this.tokens.add(string.substring(lastIdx, idx));
                        }
                        lastIdx = idx;
                        outside = false;
                        continue;
                    }
                    ++level;
                    continue;
                }
                if (string.charAt(idx) != '}' || outside) continue;
                if (level > 0) {
                    --level;
                    continue;
                }
                if (lastIdx < idx) {
                    this.tokens.add(string.substring(lastIdx, idx + 1));
                }
                lastIdx = idx + 1;
                outside = true;
            }
            if (lastIdx < idx) {
                this.tokens.add(string.substring(lastIdx, idx));
            }
        }

        public static boolean insideBraces(String token) {
            return token.charAt(0) == '{' && token.charAt(token.length() - 1) == '}';
        }

        public static String stripBraces(String token) {
            return token.substring(1, token.length() - 1);
        }

        public boolean hasNext() {
            return this.tokens.size() > this.tokenIdx;
        }

        public String next() {
            return this.tokens.get(this.tokenIdx++);
        }
    }

    private static final class PathTemplate {
        private final String name;
        private final Pattern validator;

        private PathTemplate(String name, Pattern validator) {
            this.name = name;
            this.validator = validator;
        }

        public void validate(String value) {
            Validate.isTrue(this.validator.matcher(value).matches(), "Path param %s=%s don't matches expected format %s", this.name, value, this.validator);
        }
    }

    private final class DefaultPathBuilder
    implements PathBuilder {
        private final Map<String, PathTemplate> remainingTemplates;
        private final StringBuilder url;
        private final Charset charset;

        private DefaultPathBuilder(Charset charset) {
            this.remainingTemplates = new HashMap<String, PathTemplate>(RegexPathTemplate.this.templates);
            this.url = new StringBuilder(RegexPathTemplate.this.urlTemplate);
            this.charset = charset;
        }

        public PathBuilder merge(String templateName, String templateValue, boolean encoded) throws UnsupportedEncodingException {
            int start;
            Validate.isTrue(this.remainingTemplates.containsKey(templateName), "Path parameters is unknown or has already been provided for base uri '%s' (template:%s)! Param: %s", this.url, RegexPathTemplate.this.urlTemplate, templateName);
            PathTemplate template = this.remainingTemplates.remove(templateName);
            template.validate(templateValue);
            String tmpl = "{" + templateName + "}";
            while ((start = this.url.indexOf(tmpl)) != -1) {
                this.url.replace(start, start + tmpl.length(), this.encode(templateValue, encoded));
            }
            return this;
        }

        private String encode(String value, boolean encoded) throws UnsupportedEncodingException {
            return encoded ? value : Urls.encode(value, this.charset);
        }

        public String build() {
            State.isTrue(this.remainingTemplates.isEmpty(), "Not all path templates have been merged! (url=%s)", this.url);
            return this.url.toString();
        }
    }
}

