/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.config;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.codegist.common.lang.State;
import org.codegist.common.lang.ToStringBuilder;
import org.codegist.common.reflect.Types;
import org.codegist.crest.CRestConfig;
import org.codegist.crest.config.ConfigBuilder;
import org.codegist.crest.config.DefaultParamConfig;
import org.codegist.crest.config.MethodConfigBuilder;
import org.codegist.crest.config.ParamConfig;
import org.codegist.crest.config.ParamConfigBuilder;
import org.codegist.crest.config.ParamType;
import org.codegist.crest.param.ParamProcessor;
import org.codegist.crest.param.ParamProcessors;
import org.codegist.crest.serializer.Serializer;
import org.codegist.crest.util.ComponentRegistry;
import org.codegist.crest.util.MultiParts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultParamConfigBuilder
extends ConfigBuilder
implements ParamConfigBuilder {
    private final MethodConfigBuilder parent;
    private final Class<?> clazz;
    private final Type genericType;
    private final ComponentRegistry<Class<?>, Serializer> classSerializerRegistry;
    private final Class<? extends ParamProcessor> paramProcessor;
    private final Map<String, Object> metas = new HashMap<String, Object>();
    private String name = null;
    private String defaultValue = null;
    private ParamType type = ParamType.getDefault();
    private String listSeparator = null;
    private Class<? extends Serializer> serializer = null;
    private Boolean encoded = false;

    DefaultParamConfigBuilder(CRestConfig crestConfig, ComponentRegistry<Class<?>, Serializer> classSerializerRegistry, Class<?> clazz, Type genericType) {
        this(crestConfig, classSerializerRegistry, clazz, genericType, null);
    }

    DefaultParamConfigBuilder(CRestConfig crestConfig, ComponentRegistry<Class<?>, Serializer> classSerializerRegistry, Class<?> clazz, Type genericType, MethodConfigBuilder parent) {
        super(crestConfig);
        this.parent = parent;
        this.clazz = Types.getComponentClass(clazz, genericType);
        this.genericType = Types.getComponentType(clazz, genericType);
        this.classSerializerRegistry = classSerializerRegistry;
        this.name = this.override(ParamConfig.PARAM_CONFIG_DEFAULT_NAME, this.name);
        this.defaultValue = this.override(ParamConfig.PARAM_CONFIG_DEFAULT_VALUE, this.defaultValue);
        this.type = this.override(ParamConfig.PARAM_CONFIG_DEFAULT_TYPE, this.type);
        this.listSeparator = this.override(ParamConfig.PARAM_CONFIG_DEFAULT_LIST_SEPARATOR, this.listSeparator);
        this.serializer = this.override(ParamConfig.PARAM_CONFIG_DEFAULT_SERIALIZER, this.serializer);
        this.encoded = this.override(ParamConfig.PARAM_CONFIG_DEFAULT_ENCODED, this.encoded);
        this.paramProcessor = this.override(ParamConfig.PARAM_CONFIG_DEFAULT_PROCESSOR, null);
        Map<String, Object> pMetas = this.override(ParamConfig.PARAM_CONFIG_DEFAULT_METAS, this.metas);
        if (pMetas != this.metas) {
            this.metas.clear();
            this.metas.putAll(pMetas);
        }
    }

    @Override
    public ParamConfig build() throws Exception {
        this.validate();
        return new DefaultParamConfig(this.genericType, this.clazz, this.name, this.defaultValue, this.type, this.metas, this.serializer != null ? this.instantiate(this.serializer) : this.classSerializerRegistry.get(this.clazz), ParamType.COOKIE.equals((Object)this.type) || ParamType.HEADER.equals((Object)this.type) ? true : this.encoded, this.paramProcessor != null ? this.instantiate(this.paramProcessor) : ParamProcessors.newInstance(this.type, this.listSeparator));
    }

    private void validate() {
        State.notBlank(this.name, "Parameter name is mandatory. This is probably due to a missing or empty named param annotation (one of the following: @CookieParam, @FormParam, @HeaderParam, @MatrixParam, @MultiPartParam, @PathParam, @QueryParam).\nLocation information:\n%s", this);
    }

    @Override
    public ParamConfigBuilder setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ParamConfigBuilder setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    public ParamConfigBuilder setType(ParamType type) {
        this.type = type;
        return this;
    }

    @Override
    public ParamConfigBuilder setListSeparator(String listSeparator) {
        this.listSeparator = listSeparator;
        return this;
    }

    @Override
    public ParamConfigBuilder setEncoded(boolean encoded) {
        this.encoded = encoded;
        return this;
    }

    @Override
    public ParamConfigBuilder setMetaDatas(Map<String, Object> metadatas) {
        this.metas.clear();
        this.metas.putAll(metadatas);
        return this;
    }

    @Override
    public ParamConfigBuilder setSerializer(Class<? extends Serializer> serializerClass) {
        this.serializer = serializerClass;
        return this;
    }

    @Override
    public ParamConfigBuilder forCookie() {
        return this.setType(ParamType.COOKIE);
    }

    @Override
    public ParamConfigBuilder forQuery() {
        return this.setType(ParamType.QUERY);
    }

    @Override
    public ParamConfigBuilder forPath() {
        return this.setType(ParamType.PATH);
    }

    @Override
    public ParamConfigBuilder forForm() {
        return this.setType(ParamType.FORM);
    }

    @Override
    public ParamConfigBuilder forHeader() {
        return this.setType(ParamType.HEADER);
    }

    @Override
    public ParamConfigBuilder forMatrix() {
        return this.setType(ParamType.MATRIX);
    }

    @Override
    public ParamConfigBuilder forMultiPart() {
        MultiParts.asMultipart(this.metas);
        return this.forForm();
    }

    public String toString() {
        return new ToStringBuilder("Param").append("class", this.clazz).append("type", (Object)this.type).append("method", this.parent).toString();
    }
}

