/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.config;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codegist.common.lang.State;
import org.codegist.common.lang.ToStringBuilder;
import org.codegist.common.net.Urls;
import org.codegist.crest.CRestConfig;
import org.codegist.crest.config.ConfigBuilder;
import org.codegist.crest.config.DefaultMethodConfig;
import org.codegist.crest.config.DefaultParamConfigBuilder;
import org.codegist.crest.config.InterfaceConfigBuilder;
import org.codegist.crest.config.MethodConfig;
import org.codegist.crest.config.MethodConfigBuilder;
import org.codegist.crest.config.MethodType;
import org.codegist.crest.config.ParamConfig;
import org.codegist.crest.config.ParamConfigBuilder;
import org.codegist.crest.config.RegexPathTemplate;
import org.codegist.crest.entity.EntityWriter;
import org.codegist.crest.entity.UrlEncodedFormEntityWriter;
import org.codegist.crest.entity.multipart.MultiPartEntityWriter;
import org.codegist.crest.handler.DefaultResponseHandler;
import org.codegist.crest.handler.ErrorDelegatorHandler;
import org.codegist.crest.handler.ErrorHandler;
import org.codegist.crest.handler.MaxAttemptRetryHandler;
import org.codegist.crest.handler.ResponseHandler;
import org.codegist.crest.handler.RetryHandler;
import org.codegist.crest.interceptor.NoOpRequestInterceptor;
import org.codegist.crest.interceptor.RequestInterceptor;
import org.codegist.crest.serializer.Deserializer;
import org.codegist.crest.serializer.Serializer;
import org.codegist.crest.util.ComponentRegistry;
import org.codegist.crest.util.MultiParts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultMethodConfigBuilder
extends ConfigBuilder
implements MethodConfigBuilder {
    private static final String ENDPOINT_MSG = "End-point is mandatory. This is probably due to a missing or empty @EndPoint annotation.\n" + "Either provide an @EndPoint annotation or build a CRest instance as follow:\n\n" + "   String defaultEndPoint = ...;\n" + "   CRest crest = CRest.getInstance(defaultEndPoint);\n" + "\nLocation information:\n%s";
    private final InterfaceConfigBuilder parent;
    private final Method method;
    private final List<ParamConfigBuilder> extraParamBuilders = new ArrayList<ParamConfigBuilder>();
    private final List<ParamConfigBuilder> methodParamConfigBuilders = new ArrayList<ParamConfigBuilder>();
    private final ComponentRegistry<String, Deserializer> mimeDeserializerRegistry;
    private final ComponentRegistry<Class<?>, Serializer> classSerializerRegistry;
    private final ParamConfig[] extraParams;
    private String endPoint = null;
    private String produces = null;
    private Charset charset = Charset.forName("UTF-8");
    private MethodType meth = MethodType.getDefault();
    private Integer socketTimeout = 20000;
    private Integer connectionTimeout = 20000;
    private Class<? extends RequestInterceptor> requestInterceptor = NoOpRequestInterceptor.class;
    private Class<? extends ResponseHandler> responseHandler = DefaultResponseHandler.class;
    private Class<? extends ErrorHandler> errorHandler = ErrorDelegatorHandler.class;
    private Class<? extends RetryHandler> retryHandler = MaxAttemptRetryHandler.class;
    private Class<? extends EntityWriter> entityWriter = null;
    private final List<Class<? extends Deserializer>> deserializers = new ArrayList<Class<? extends Deserializer>>();
    private final List<String> pathSegments = new ArrayList<String>();
    private final List<String> consumes = new ArrayList<String>(Arrays.asList("*/*"));

    DefaultMethodConfigBuilder(InterfaceConfigBuilder parent, Method method, CRestConfig crestConfig, ComponentRegistry<String, Deserializer> mimeDeserializerRegistry, ComponentRegistry<Class<?>, Serializer> classSerializerRegistry) {
        super(crestConfig);
        List<String> pPathSegments;
        List<String> pConsumes;
        this.parent = parent;
        this.method = method;
        this.mimeDeserializerRegistry = mimeDeserializerRegistry;
        this.classSerializerRegistry = classSerializerRegistry;
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            DefaultParamConfigBuilder pcb = new DefaultParamConfigBuilder(crestConfig, classSerializerRegistry, method.getParameterTypes()[i], method.getGenericParameterTypes()[i], this);
            this.methodParamConfigBuilders.add(pcb);
        }
        this.endPoint = this.override(MethodConfig.METHOD_CONFIG_DEFAULT_ENDPOINT, this.endPoint);
        this.produces = this.override(MethodConfig.METHOD_CONFIG_DEFAULT_PRODUCES, this.produces);
        this.charset = this.override(MethodConfig.METHOD_CONFIG_DEFAULT_CHARSET, this.charset);
        this.meth = this.override(MethodConfig.METHOD_CONFIG_DEFAULT_TYPE, this.meth);
        this.socketTimeout = this.override(MethodConfig.METHOD_CONFIG_DEFAULT_SO_TIMEOUT, this.socketTimeout);
        this.connectionTimeout = this.override(MethodConfig.METHOD_CONFIG_DEFAULT_CO_TIMEOUT, this.connectionTimeout);
        this.requestInterceptor = this.override(MethodConfig.METHOD_CONFIG_DEFAULT_REQUEST_INTERCEPTOR, this.requestInterceptor);
        this.responseHandler = this.override(MethodConfig.METHOD_CONFIG_DEFAULT_RESPONSE_HANDLER, this.responseHandler);
        this.errorHandler = this.override(MethodConfig.METHOD_CONFIG_DEFAULT_ERROR_HANDLER, this.errorHandler);
        this.retryHandler = this.override(MethodConfig.METHOD_CONFIG_DEFAULT_RETRY_HANDLER, this.retryHandler);
        this.entityWriter = this.override(MethodConfig.METHOD_CONFIG_DEFAULT_ENTITY_WRITER, this.entityWriter);
        this.extraParams = this.override(MethodConfig.METHOD_CONFIG_DEFAULT_EXTRA_PARAMS, new ParamConfig[0]);
        List<Class<? extends Deserializer>> pDeserializers = this.override(MethodConfig.METHOD_CONFIG_DEFAULT_DESERIALIZERS, this.deserializers);
        if (pDeserializers != this.deserializers) {
            this.deserializers.clear();
            this.deserializers.addAll(pDeserializers);
        }
        if ((pConsumes = this.override(MethodConfig.METHOD_CONFIG_DEFAULT_CONSUMES, this.consumes)) != this.consumes) {
            this.consumes.clear();
            this.consumes.addAll(pConsumes);
        }
        if ((pPathSegments = this.override(MethodConfig.METHOD_CONFIG_DEFAULT_PATH, this.pathSegments)) != this.pathSegments) {
            this.pathSegments.clear();
            this.pathSegments.addAll(pPathSegments);
        }
    }

    @Override
    public MethodConfig build() throws Exception {
        this.validate();
        ParamConfig[] pConfigMethod = DefaultMethodConfigBuilder.buildParams(this.methodParamConfigBuilders);
        ParamConfig[] pExtraParams = org.codegist.common.collect.Arrays.merge(ParamConfig.class, this.extraParams, DefaultMethodConfigBuilder.buildParams(this.extraParamBuilders));
        ParamConfig[] allParams = org.codegist.common.collect.Arrays.merge(ParamConfig.class, pConfigMethod, pExtraParams);
        return new DefaultMethodConfig(this.charset, this.method, RegexPathTemplate.create(this.buildPath()), this.produces, org.codegist.common.collect.Arrays.arrify(this.consumes, String.class), this.meth, this.socketTimeout, this.connectionTimeout, this.getEntityWriter(allParams), this.instantiate(this.requestInterceptor), this.instantiate(this.responseHandler), this.instantiate(this.errorHandler), this.instantiate(this.retryHandler), this.getDeserializers(), pConfigMethod, pExtraParams);
    }

    private void validate() {
        State.notBlank(this.endPoint, ENDPOINT_MSG, this);
    }

    private Deserializer[] getDeserializers() {
        ArrayList<Deserializer> pDeserializers = new ArrayList<Deserializer>();
        for (Class<? extends Deserializer> deserializerCls : this.deserializers) {
            pDeserializers.add(this.instantiate(deserializerCls));
        }
        for (String consume : this.consumes) {
            if ("*/*".equals(consume)) continue;
            pDeserializers.add(this.mimeDeserializerRegistry.get(consume));
        }
        return org.codegist.common.collect.Arrays.arrify(pDeserializers, Deserializer.class);
    }

    private EntityWriter getEntityWriter(ParamConfig[] params) {
        if (this.entityWriter != null) {
            return this.instantiate(this.entityWriter);
        }
        if (!this.meth.hasEntity()) {
            return null;
        }
        if (MultiParts.hasMultiPart(params)) {
            return this.instantiate(MultiPartEntityWriter.class);
        }
        return this.instantiate(UrlEncodedFormEntityWriter.class);
    }

    private String buildPath() {
        ArrayList<String> pPathParts = new ArrayList<String>(this.pathSegments);
        pPathParts.add(0, this.endPoint);
        String[] paths = org.codegist.common.collect.Arrays.arrify(pPathParts, String.class);
        return paths.length > 1 ? Urls.normalizeSlashes(org.codegist.common.collect.Arrays.join("/", paths)) : paths[0];
    }

    private static ParamConfig[] buildParams(List<ParamConfigBuilder> paramConfigBuilders) throws Exception {
        ParamConfig[] pc = new ParamConfig[paramConfigBuilders.size()];
        for (int i = 0; i < paramConfigBuilders.size(); ++i) {
            pc[i] = paramConfigBuilders.get(i).build();
        }
        return pc;
    }

    @Override
    public ParamConfigBuilder startParamConfig(int index) {
        return this.methodParamConfigBuilders.get(index);
    }

    @Override
    public ParamConfigBuilder startExtraParamConfig() {
        DefaultParamConfigBuilder pcb = new DefaultParamConfigBuilder(this.getCRestConfig(), this.classSerializerRegistry, String.class, (Type)((Object)String.class), this);
        this.extraParamBuilders.add(pcb);
        return pcb;
    }

    @Override
    public MethodConfigBuilder setConsumes(String ... mimeTypes) {
        this.consumes.clear();
        this.consumes.addAll(Arrays.asList(mimeTypes));
        return this;
    }

    @Override
    public MethodConfigBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public MethodConfigBuilder setProduces(String contentType) {
        this.produces = contentType;
        return this;
    }

    @Override
    public MethodConfigBuilder appendPath(String path) {
        this.pathSegments.add(path);
        return this;
    }

    @Override
    public MethodConfigBuilder setEndPoint(String endPoint) {
        this.endPoint = endPoint;
        return this;
    }

    @Override
    public MethodConfigBuilder setType(MethodType meth) {
        this.meth = meth;
        return this;
    }

    @Override
    public MethodConfigBuilder setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    @Override
    public MethodConfigBuilder setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    @Override
    public MethodConfigBuilder setDeserializer(Class<? extends Deserializer> deserializerClass) {
        this.deserializers.clear();
        this.deserializers.add(deserializerClass);
        return this;
    }

    @Override
    public MethodConfigBuilder setRequestInterceptor(Class<? extends RequestInterceptor> requestInterceptorClass) {
        this.requestInterceptor = requestInterceptorClass;
        return this;
    }

    @Override
    public MethodConfigBuilder setResponseHandler(Class<? extends ResponseHandler> responseHandlerClass) {
        this.responseHandler = responseHandlerClass;
        return this;
    }

    @Override
    public MethodConfigBuilder setErrorHandler(Class<? extends ErrorHandler> errorHandlerClass) {
        this.errorHandler = errorHandlerClass;
        return this;
    }

    @Override
    public MethodConfigBuilder setRetryHandler(Class<? extends RetryHandler> retryHandlerClass) {
        this.retryHandler = retryHandlerClass;
        return this;
    }

    @Override
    public MethodConfigBuilder setEntityWriter(Class<? extends EntityWriter> entityWriterClass) {
        this.entityWriter = entityWriterClass;
        return this;
    }

    @Override
    public MethodConfigBuilder setParamsSerializer(Class<? extends Serializer> serializerClass) {
        for (ParamConfigBuilder b : this.methodParamConfigBuilders) {
            b.setSerializer(serializerClass);
        }
        return this;
    }

    @Override
    public MethodConfigBuilder setParamsEncoded(boolean encoded) {
        for (ParamConfigBuilder b : this.methodParamConfigBuilders) {
            b.setEncoded(encoded);
        }
        return this;
    }

    @Override
    public MethodConfigBuilder setParamsListSeparator(String listSeparator) {
        for (ParamConfigBuilder b : this.methodParamConfigBuilders) {
            b.setListSeparator(listSeparator);
        }
        return this;
    }

    public String toString() {
        return new ToStringBuilder("Method").append("method", this.method).append("interface", this.parent).toString();
    }
}

