/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.config;

import java.lang.reflect.Method;
import java.nio.charset.Charset;
import org.codegist.crest.config.MethodConfig;
import org.codegist.crest.config.MethodType;
import org.codegist.crest.config.ParamConfig;
import org.codegist.crest.config.PathTemplate;
import org.codegist.crest.entity.EntityWriter;
import org.codegist.crest.handler.ErrorHandler;
import org.codegist.crest.handler.ResponseHandler;
import org.codegist.crest.handler.RetryHandler;
import org.codegist.crest.interceptor.RequestInterceptor;
import org.codegist.crest.serializer.Deserializer;

class DefaultMethodConfig
implements MethodConfig {
    private final Charset charset;
    private final Method method;
    private final PathTemplate path;
    private final String produces;
    private final String[] consumes;
    private final MethodType type;
    private final int socketTimeout;
    private final int connectionTimeout;
    private final EntityWriter entityWriter;
    private final RequestInterceptor requestInterceptor;
    private final ResponseHandler responseHandler;
    private final ErrorHandler errorHandler;
    private final RetryHandler retryHandler;
    private final Deserializer[] deserializers;
    private final ParamConfig[] extraParams;
    private final ParamConfig[] methodParamConfigs;

    DefaultMethodConfig(Charset charset, Method method, PathTemplate path, String produces, String[] consumes, MethodType type, int socketTimeout, int connectionTimeout, EntityWriter entityWriter, RequestInterceptor requestInterceptor, ResponseHandler responseHandler, ErrorHandler errorHandler, RetryHandler retryHandler, Deserializer[] deserializers, ParamConfig[] methodParamConfigs, ParamConfig[] extraParams) {
        this.charset = charset;
        this.method = method;
        this.path = path;
        this.produces = produces;
        this.consumes = (String[])consumes.clone();
        this.type = type;
        this.socketTimeout = socketTimeout;
        this.connectionTimeout = connectionTimeout;
        this.entityWriter = entityWriter;
        this.requestInterceptor = requestInterceptor;
        this.responseHandler = responseHandler;
        this.errorHandler = errorHandler;
        this.retryHandler = retryHandler;
        this.deserializers = (Deserializer[])deserializers.clone();
        this.methodParamConfigs = (ParamConfig[])methodParamConfigs.clone();
        this.extraParams = (ParamConfig[])extraParams.clone();
    }

    public Charset getCharset() {
        return this.charset;
    }

    public PathTemplate getPathTemplate() {
        return this.path;
    }

    public ResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    public String getProduces() {
        return this.produces;
    }

    public String[] getConsumes() {
        return (String[])this.consumes.clone();
    }

    public Method getMethod() {
        return this.method;
    }

    public MethodType getType() {
        return this.type;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public EntityWriter getEntityWriter() {
        return this.entityWriter;
    }

    public RequestInterceptor getRequestInterceptor() {
        return this.requestInterceptor;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public RetryHandler getRetryHandler() {
        return this.retryHandler;
    }

    public Deserializer[] getDeserializers() {
        return (Deserializer[])this.deserializers.clone();
    }

    public ParamConfig getParamConfig(int index) {
        return this.methodParamConfigs[index];
    }

    public int getParamCount() {
        return this.methodParamConfigs.length;
    }

    public ParamConfig[] getExtraParams() {
        return (ParamConfig[])this.extraParams.clone();
    }
}

