/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.config;

import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codegist.common.lang.ToStringBuilder;
import org.codegist.crest.CRestConfig;
import org.codegist.crest.config.ConfigBuilder;
import org.codegist.crest.config.DefaultInterfaceConfig;
import org.codegist.crest.config.DefaultMethodConfigBuilder;
import org.codegist.crest.config.InterfaceConfig;
import org.codegist.crest.config.InterfaceConfigBuilder;
import org.codegist.crest.config.MethodConfig;
import org.codegist.crest.config.MethodConfigBuilder;
import org.codegist.crest.config.MethodType;
import org.codegist.crest.config.ParamConfig;
import org.codegist.crest.config.ParamConfigBuilder;
import org.codegist.crest.config.ParamType;
import org.codegist.crest.entity.EntityWriter;
import org.codegist.crest.handler.ErrorHandler;
import org.codegist.crest.handler.ResponseHandler;
import org.codegist.crest.handler.RetryHandler;
import org.codegist.crest.interceptor.RequestInterceptor;
import org.codegist.crest.serializer.Deserializer;
import org.codegist.crest.serializer.Serializer;
import org.codegist.crest.util.ComponentRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultInterfaceConfigBuilder
extends ConfigBuilder
implements InterfaceConfigBuilder {
    private final Class interfaze;
    private final Map<Method, MethodConfigBuilder> methodBuilders;

    public DefaultInterfaceConfigBuilder(Class interfaze, CRestConfig crestConfig, ComponentRegistry<String, Deserializer> mimeDeserializerRegistry, ComponentRegistry<Class<?>, Serializer> classSerializerRegistry) {
        super(crestConfig);
        this.interfaze = interfaze;
        this.methodBuilders = new HashMap<Method, MethodConfigBuilder>();
        for (Method m : interfaze.getDeclaredMethods()) {
            this.methodBuilders.put(m, new DefaultMethodConfigBuilder(this, m, crestConfig, mimeDeserializerRegistry, classSerializerRegistry));
        }
    }

    @Override
    public InterfaceConfig build() throws Exception {
        HashMap<Method, MethodConfig> mConfig = new HashMap<Method, MethodConfig>();
        for (Map.Entry<Method, MethodConfigBuilder> entry : this.methodBuilders.entrySet()) {
            mConfig.put(entry.getKey(), entry.getValue().build());
        }
        return new DefaultInterfaceConfig(this.interfaze, mConfig);
    }

    @Override
    public MethodConfigBuilder startMethodConfig(Method meth) {
        return this.methodBuilders.get(meth);
    }

    @Override
    public InterfaceConfigBuilder setMethodsCharset(Charset charset) {
        for (MethodConfigBuilder b : this.methodBuilders.values()) {
            b.setCharset(charset);
        }
        return this;
    }

    @Override
    public InterfaceConfigBuilder setMethodsSocketTimeout(int socketTimeout) {
        for (MethodConfigBuilder b : this.methodBuilders.values()) {
            b.setSocketTimeout(socketTimeout);
        }
        return this;
    }

    @Override
    public InterfaceConfigBuilder setMethodsConnectionTimeout(int connectionTimeout) {
        for (MethodConfigBuilder b : this.methodBuilders.values()) {
            b.setConnectionTimeout(connectionTimeout);
        }
        return this;
    }

    @Override
    public InterfaceConfigBuilder setMethodsRequestInterceptor(Class<? extends RequestInterceptor> requestInterceptorClass) {
        for (MethodConfigBuilder b : this.methodBuilders.values()) {
            b.setRequestInterceptor(requestInterceptorClass);
        }
        return this;
    }

    @Override
    public InterfaceConfigBuilder setMethodsResponseHandler(Class<? extends ResponseHandler> responseHandlerClass) {
        for (MethodConfigBuilder b : this.methodBuilders.values()) {
            b.setResponseHandler(responseHandlerClass);
        }
        return this;
    }

    @Override
    public InterfaceConfigBuilder setMethodsErrorHandler(Class<? extends ErrorHandler> errorHandlerClass) {
        for (MethodConfigBuilder b : this.methodBuilders.values()) {
            b.setErrorHandler(errorHandlerClass);
        }
        return this;
    }

    @Override
    public InterfaceConfigBuilder setMethodsRetryHandler(Class<? extends RetryHandler> retryHandlerClass) {
        for (MethodConfigBuilder b : this.methodBuilders.values()) {
            b.setRetryHandler(retryHandlerClass);
        }
        return this;
    }

    @Override
    public InterfaceConfigBuilder setMethodsEntityWriter(Class<? extends EntityWriter> entityWriterClass) {
        for (MethodConfigBuilder b : this.methodBuilders.values()) {
            b.setEntityWriter(entityWriterClass);
        }
        return this;
    }

    @Override
    public InterfaceConfigBuilder setMethodsConsumes(String ... mimeTypes) {
        for (MethodConfigBuilder b : this.methodBuilders.values()) {
            b.setConsumes(mimeTypes);
        }
        return this;
    }

    @Override
    public InterfaceConfigBuilder setMethodsDeserializer(Class<? extends Deserializer> deserializerClass) {
        for (MethodConfigBuilder b : this.methodBuilders.values()) {
            b.setDeserializer(deserializerClass);
        }
        return this;
    }

    @Override
    public InterfaceConfigBuilder setMethodsProduces(String contentType) {
        for (MethodConfigBuilder b : this.methodBuilders.values()) {
            b.setProduces(contentType);
        }
        return this;
    }

    @Override
    public InterfaceConfigBuilder setMethodsType(MethodType meth) {
        for (MethodConfigBuilder b : this.methodBuilders.values()) {
            b.setType(meth);
        }
        return this;
    }

    @Override
    public InterfaceConfigBuilder appendMethodsPath(String path) {
        for (MethodConfigBuilder b : this.methodBuilders.values()) {
            b.appendPath(path);
        }
        return this;
    }

    @Override
    public InterfaceConfigBuilder setMethodsEndPoint(String endPoint) {
        for (MethodConfigBuilder b : this.methodBuilders.values()) {
            b.setEndPoint(endPoint);
        }
        return this;
    }

    @Override
    public ParamConfigBuilder startMethodsExtraParamConfig() {
        Iterator<MethodConfigBuilder> methodConfigBuilders = this.methodBuilders.values().iterator();
        ParamConfigBuilder[] builders = new ParamConfigBuilder[this.methodBuilders.size()];
        int i = 0;
        while (methodConfigBuilders.hasNext()) {
            builders[i++] = methodConfigBuilders.next().startExtraParamConfig();
        }
        return new CompositeParamConfigBuilder(builders);
    }

    @Override
    public InterfaceConfigBuilder setParamsSerializer(Class<? extends Serializer> paramSerializerClass) {
        for (MethodConfigBuilder b : this.methodBuilders.values()) {
            b.setParamsSerializer(paramSerializerClass);
        }
        return this;
    }

    @Override
    public InterfaceConfigBuilder setParamsEncoded(boolean encoded) {
        for (MethodConfigBuilder b : this.methodBuilders.values()) {
            b.setParamsEncoded(encoded);
        }
        return this;
    }

    @Override
    public InterfaceConfigBuilder setParamsListSeparator(String separator) {
        for (MethodConfigBuilder b : this.methodBuilders.values()) {
            b.setParamsListSeparator(separator);
        }
        return this;
    }

    public String toString() {
        return new ToStringBuilder("Interface").append("interface", this.interfaze).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CompositeParamConfigBuilder
    implements ParamConfigBuilder {
        private final ParamConfigBuilder[] builders;

        CompositeParamConfigBuilder(ParamConfigBuilder[] builders) {
            this.builders = (ParamConfigBuilder[])builders.clone();
        }

        @Override
        public ParamConfig build() throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        public ParamConfigBuilder setName(String name) {
            for (ParamConfigBuilder builder : this.builders) {
                builder.setName(name);
            }
            return this;
        }

        @Override
        public ParamConfigBuilder setDefaultValue(String defaultValue) {
            for (ParamConfigBuilder builder : this.builders) {
                builder.setDefaultValue(defaultValue);
            }
            return this;
        }

        @Override
        public ParamConfigBuilder setType(ParamType type) {
            for (ParamConfigBuilder builder : this.builders) {
                builder.setType(type);
            }
            return this;
        }

        @Override
        public ParamConfigBuilder setListSeparator(String listSeparator) {
            for (ParamConfigBuilder builder : this.builders) {
                builder.setListSeparator(listSeparator);
            }
            return this;
        }

        @Override
        public ParamConfigBuilder setEncoded(boolean encoded) {
            for (ParamConfigBuilder builder : this.builders) {
                builder.setEncoded(encoded);
            }
            return this;
        }

        @Override
        public ParamConfigBuilder setMetaDatas(Map<String, Object> metadatas) {
            for (ParamConfigBuilder builder : this.builders) {
                builder.setMetaDatas(metadatas);
            }
            return this;
        }

        @Override
        public ParamConfigBuilder setSerializer(Class<? extends Serializer> serializerClass) {
            for (ParamConfigBuilder builder : this.builders) {
                builder.setSerializer(serializerClass);
            }
            return this;
        }

        @Override
        public ParamConfigBuilder forCookie() {
            for (ParamConfigBuilder builder : this.builders) {
                builder.forCookie();
            }
            return this;
        }

        @Override
        public ParamConfigBuilder forQuery() {
            for (ParamConfigBuilder builder : this.builders) {
                builder.forQuery();
            }
            return this;
        }

        @Override
        public ParamConfigBuilder forPath() {
            for (ParamConfigBuilder builder : this.builders) {
                builder.forPath();
            }
            return this;
        }

        @Override
        public ParamConfigBuilder forForm() {
            for (ParamConfigBuilder builder : this.builders) {
                builder.forForm();
            }
            return this;
        }

        @Override
        public ParamConfigBuilder forHeader() {
            for (ParamConfigBuilder builder : this.builders) {
                builder.forHeader();
            }
            return this;
        }

        @Override
        public ParamConfigBuilder forMatrix() {
            for (ParamConfigBuilder builder : this.builders) {
                builder.forMatrix();
            }
            return this;
        }

        @Override
        public ParamConfigBuilder forMultiPart() {
            for (ParamConfigBuilder builder : this.builders) {
                builder.forMultiPart();
            }
            return this;
        }
    }
}

