/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.codegist.common.collect.Arrays;
import org.codegist.common.reflect.Types;
import org.codegist.crest.config.InterfaceConfig;
import org.codegist.crest.config.InterfaceConfigBuilder;
import org.codegist.crest.config.InterfaceConfigBuilderFactory;
import org.codegist.crest.config.InterfaceConfigFactory;
import org.codegist.crest.config.MethodConfigBuilder;
import org.codegist.crest.config.ParamConfigBuilder;
import org.codegist.crest.config.annotate.AnnotationHandler;
import org.codegist.crest.util.ComponentRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationDrivenInterfaceConfigFactory
implements InterfaceConfigFactory {
    private final InterfaceConfigBuilderFactory icbf;
    private final ComponentRegistry<Class<? extends Annotation>, AnnotationHandler> handlersRegistry;

    public AnnotationDrivenInterfaceConfigFactory(InterfaceConfigBuilderFactory icbf, ComponentRegistry<Class<? extends Annotation>, AnnotationHandler> handlersRegistry) {
        this.handlersRegistry = handlersRegistry;
        this.icbf = icbf;
    }

    @Override
    public InterfaceConfig newConfig(Class<?> interfaze) throws Exception {
        InterfaceConfigBuilder config = this.icbf.newInstance(interfaze);
        for (Annotation annotation : interfaze.getAnnotations()) {
            this.handlersRegistry.get(annotation.annotationType()).handleInterfaceAnnotation(annotation, config);
        }
        for (Method meth : interfaze.getDeclaredMethods()) {
            MethodConfigBuilder methodConfigBuilder = config.startMethodConfig(meth);
            for (Annotation methAnnotation : meth.getAnnotations()) {
                this.handlersRegistry.get(methAnnotation.annotationType()).handleMethodAnnotation(methAnnotation, methodConfigBuilder);
            }
            Class<?>[] paramTypes = meth.getParameterTypes();
            Type[] genParamTypes = meth.getGenericParameterTypes();
            Annotation[][] paramAnnotations = meth.getParameterAnnotations();
            int max = paramTypes.length;
            for (int i = 0; i < max; ++i) {
                Type pType = genParamTypes[i];
                Class<?> pClass = Types.getComponentClass(paramTypes[i], pType);
                Annotation[] annotations = Arrays.merge(Annotation.class, pClass.getAnnotations(), paramAnnotations[i]);
                ParamConfigBuilder methodParamConfigBuilder = methodConfigBuilder.startParamConfig(i);
                for (Annotation paramAnnotation : annotations) {
                    this.handlersRegistry.get(paramAnnotation.annotationType()).handleParameterAnnotation(paramAnnotation, methodParamConfigBuilder);
                }
            }
        }
        return config.build();
    }
}

