/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest;

import java.lang.reflect.Method;
import org.codegist.common.lang.Disposables;
import org.codegist.common.reflect.ObjectMethodsAwareInvocationHandler;
import org.codegist.common.reflect.ProxyFactory;
import org.codegist.crest.CRest;
import org.codegist.crest.CRestException;
import org.codegist.crest.config.InterfaceConfig;
import org.codegist.crest.config.InterfaceConfigFactory;
import org.codegist.crest.config.MethodConfig;
import org.codegist.crest.io.Request;
import org.codegist.crest.io.RequestBuilderFactory;
import org.codegist.crest.io.RequestExecutor;
import org.codegist.crest.io.Response;
import org.codegist.crest.util.Requests;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultCRest
extends CRest {
    private final ProxyFactory proxyFactory;
    private final RequestExecutor requestExecutor;
    private final RequestBuilderFactory requestBuilderFactory;
    private final InterfaceConfigFactory configFactory;

    public DefaultCRest(ProxyFactory proxyFactory, RequestExecutor requestExecutor, RequestBuilderFactory requestBuilderFactory, InterfaceConfigFactory configFactory) {
        this.proxyFactory = proxyFactory;
        this.requestExecutor = requestExecutor;
        this.requestBuilderFactory = requestBuilderFactory;
        this.configFactory = configFactory;
    }

    @Override
    public <T> T build(Class<T> interfaze) throws CRestException {
        try {
            InterfaceConfig interfaceConfig = this.configFactory.newConfig(interfaze);
            return this.proxyFactory.createProxy(interfaze.getClassLoader(), new CRestInvocationHandler(interfaceConfig), new Class[]{interfaze});
        }
        catch (Exception e) {
            throw CRestException.handle(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class CRestInvocationHandler<T>
    extends ObjectMethodsAwareInvocationHandler {
        private final InterfaceConfig interfaceConfig;

        CRestInvocationHandler(InterfaceConfig interfaceConfig) throws Exception {
            this.interfaceConfig = interfaceConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object doInvoke(Object proxy, Method method, Object[] args) throws Throwable {
            MethodConfig mc = this.interfaceConfig.getMethodConfig(method);
            Request request = Requests.from(DefaultCRest.this.requestBuilderFactory, mc, args);
            Response response = null;
            try {
                response = DefaultCRest.this.requestExecutor.execute(request);
                return mc.getResponseHandler().handle(response);
            }
            catch (Exception e) {
                Object t;
                try {
                    t = mc.getErrorHandler().handle(request, e);
                }
                catch (Throwable throwable) {
                    Disposables.dispose(response, e);
                    throw throwable;
                }
                Disposables.dispose(response, e);
                return t;
            }
        }
    }
}

