/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.codegist.common.collect.Arrays;
import org.codegist.common.collect.Collections;
import org.codegist.common.collect.Maps;
import org.codegist.common.reflect.JdkProxyFactory;
import org.codegist.common.reflect.ProxyFactory;
import org.codegist.crest.CRest;
import org.codegist.crest.CRestConfig;
import org.codegist.crest.CRestException;
import org.codegist.crest.DefaultCRest;
import org.codegist.crest.DefaultCRestConfig;
import org.codegist.crest.config.AnnotationDrivenInterfaceConfigFactory;
import org.codegist.crest.config.DefaultInterfaceConfigBuilderFactory;
import org.codegist.crest.config.DefaultParamConfigBuilderFactory;
import org.codegist.crest.config.MethodConfig;
import org.codegist.crest.config.ParamConfigBuilderFactory;
import org.codegist.crest.config.annotate.AnnotationHandler;
import org.codegist.crest.config.annotate.CRestAnnotations;
import org.codegist.crest.config.annotate.NoOpAnnotationHandler;
import org.codegist.crest.config.annotate.jaxrs.JaxRsAnnotations;
import org.codegist.crest.handler.DefaultResponseHandler;
import org.codegist.crest.io.RequestBuilderFactory;
import org.codegist.crest.io.RequestExecutor;
import org.codegist.crest.io.RetryingRequestExecutor;
import org.codegist.crest.io.http.AuthorizationHttpChannelFactory;
import org.codegist.crest.io.http.EntityParamExtractor;
import org.codegist.crest.io.http.HttpChannelFactory;
import org.codegist.crest.io.http.HttpRequestBuilderFactory;
import org.codegist.crest.io.http.HttpRequestExecutor;
import org.codegist.crest.io.http.HttpURLConnectionHttpChannelFactory;
import org.codegist.crest.io.http.UrlEncodedFormEntityParamExtractor;
import org.codegist.crest.security.Authorization;
import org.codegist.crest.security.basic.BasicAuthorization;
import org.codegist.crest.security.handler.RefreshAuthorizationRetryHandler;
import org.codegist.crest.security.oauth.OAuthApi;
import org.codegist.crest.security.oauth.OAuthToken;
import org.codegist.crest.security.oauth.OAuthorization;
import org.codegist.crest.security.oauth.v1.OAuthApiV1Builder;
import org.codegist.crest.security.oauth.v1.OAuthenticatorV1;
import org.codegist.crest.serializer.DateDeserializer;
import org.codegist.crest.serializer.DateSerializer;
import org.codegist.crest.serializer.Deserializer;
import org.codegist.crest.serializer.FileSerializer;
import org.codegist.crest.serializer.InputStreamDeserializer;
import org.codegist.crest.serializer.InputStreamSerializer;
import org.codegist.crest.serializer.ReaderDeserializer;
import org.codegist.crest.serializer.ReaderSerializer;
import org.codegist.crest.serializer.ResponseDeserializer;
import org.codegist.crest.serializer.ResponseDeserializerByClass;
import org.codegist.crest.serializer.ResponseDeserializerByDeserializers;
import org.codegist.crest.serializer.ResponseDeserializerByMimeType;
import org.codegist.crest.serializer.ResponseDeserializerComposite;
import org.codegist.crest.serializer.Serializer;
import org.codegist.crest.serializer.StringDeserializer;
import org.codegist.crest.serializer.ToStringSerializer;
import org.codegist.crest.serializer.jackson.JacksonDeserializer;
import org.codegist.crest.serializer.jaxb.JaxbDeserializer;
import org.codegist.crest.serializer.primitive.BooleanPrimitiveDeserializer;
import org.codegist.crest.serializer.primitive.BooleanSerializer;
import org.codegist.crest.serializer.primitive.BooleanWrapperDeserializer;
import org.codegist.crest.serializer.primitive.ByteArrayDeserializer;
import org.codegist.crest.serializer.primitive.BytePrimitiveDeserializer;
import org.codegist.crest.serializer.primitive.ByteWrapperDeserializer;
import org.codegist.crest.serializer.primitive.CharacterPrimitiveDeserializer;
import org.codegist.crest.serializer.primitive.CharacterWrapperDeserializer;
import org.codegist.crest.serializer.primitive.DoublePrimitiveDeserializer;
import org.codegist.crest.serializer.primitive.DoubleWrapperDeserializer;
import org.codegist.crest.serializer.primitive.FloatPrimitiveDeserializer;
import org.codegist.crest.serializer.primitive.FloatWrapperDeserializer;
import org.codegist.crest.serializer.primitive.IntegerPrimitiveDeserializer;
import org.codegist.crest.serializer.primitive.IntegerWrapperDeserializer;
import org.codegist.crest.serializer.primitive.LongPrimitiveDeserializer;
import org.codegist.crest.serializer.primitive.LongWrapperDeserializer;
import org.codegist.crest.serializer.primitive.ShortPrimitiveDeserializer;
import org.codegist.crest.serializer.primitive.ShortWrapperDeserializer;
import org.codegist.crest.serializer.primitive.VoidDeserializer;
import org.codegist.crest.util.ComponentFactory;
import org.codegist.crest.util.ComponentRegistry;
import org.codegist.crest.util.Placeholders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRestBuilder {
    private static final int MIN_ERROR_STATUS_CODE = 400;
    private final Map<String, Object> crestProperties = new HashMap<String, Object>();
    private final RequestBuilderFactory requestBuilderFactory = new HttpRequestBuilderFactory();
    private final Map<String, String> placeholders = new HashMap<String, String>();
    private final Map<String, EntityParamExtractor> httpEntityParamExtrators = new HashMap<String, UrlEncodedFormEntityParamExtractor>(java.util.Collections.singletonMap("application/x-www-form-urlencoded", new UrlEncodedFormEntityParamExtractor()));
    private final Set<String> plainTextMimes = Collections.asSet("plain/text");
    private final Set<String> xmlMimes = Collections.asSet("application/xml", "text/xml");
    private final Set<String> jsonMimes = Collections.asSet("application/json", "application/javascript", "text/javascript", "text/json");
    private final Map<String, Object> xmlDeserializerConfig = new HashMap<String, Object>();
    private final Map<String, Object> jsonDeserializerConfig = new HashMap<String, Object>();
    private final ComponentRegistry.Builder<Class<? extends Annotation>, AnnotationHandler> annotationHandlerBuilder = new ComponentRegistry.Builder().defaultAs(NoOpAnnotationHandler.class).register(CRestAnnotations.getMapping());
    private final ComponentRegistry.Builder<String, Deserializer> mimeDeserializerBuilder = new ComponentRegistry.Builder();
    private final ComponentRegistry.Builder<Class<?>, Deserializer> classDeserializerBuilder = new ComponentRegistry.Builder<Class, VoidDeserializer>().register(VoidDeserializer.class, Void.class, Void.TYPE).register(ByteArrayDeserializer.class, (Class[])new Class[]{byte[].class}).register(StringDeserializer.class, (Class[])new Class[]{String.class}).register(ByteWrapperDeserializer.class, (Class[])new Class[]{Byte.class}).register(BytePrimitiveDeserializer.class, (Class[])new Class[]{Byte.TYPE}).register(ShortWrapperDeserializer.class, (Class[])new Class[]{Short.class}).register(ShortPrimitiveDeserializer.class, (Class[])new Class[]{Short.TYPE}).register(IntegerWrapperDeserializer.class, (Class[])new Class[]{Integer.class}).register(IntegerPrimitiveDeserializer.class, (Class[])new Class[]{Integer.TYPE}).register(LongWrapperDeserializer.class, (Class[])new Class[]{Long.class}).register(LongPrimitiveDeserializer.class, (Class[])new Class[]{Long.TYPE}).register(DoubleWrapperDeserializer.class, (Class[])new Class[]{Double.class}).register(DoublePrimitiveDeserializer.class, (Class[])new Class[]{Double.TYPE}).register(FloatWrapperDeserializer.class, (Class[])new Class[]{Float.class}).register(FloatPrimitiveDeserializer.class, (Class[])new Class[]{Float.TYPE}).register(BooleanWrapperDeserializer.class, (Class[])new Class[]{Boolean.class}).register(BooleanPrimitiveDeserializer.class, (Class[])new Class[]{Boolean.TYPE}).register(CharacterWrapperDeserializer.class, (Class[])new Class[]{Character.class}).register(CharacterPrimitiveDeserializer.class, (Class[])new Class[]{Character.TYPE}).register(DateDeserializer.class, (Class[])new Class[]{Date.class}).register(InputStreamDeserializer.class, (Class[])new Class[]{InputStream.class}).register(ReaderDeserializer.class, (Class[])new Class[]{Reader.class});
    private final ComponentRegistry.Builder<Class<?>, Serializer> classSerializerBuilder = new ComponentRegistry.Builder().defaultAs(ToStringSerializer.class).register(DateSerializer.class, Date.class).register(BooleanSerializer.class, (Class[])new Class[]{Boolean.class, Boolean.TYPE}).register(FileSerializer.class, (Class[])new Class[]{File.class}).register(InputStreamSerializer.class, (Class[])new Class[]{InputStream.class}).register(ReaderSerializer.class, (Class[])new Class[]{Reader.class});
    private Class<? extends ProxyFactory> proxyFactoryClass = JdkProxyFactory.class;
    private Class<? extends Deserializer> xmlDeserializer = JaxbDeserializer.class;
    private Class<? extends Deserializer> jsonDeserializer = JacksonDeserializer.class;
    private Class<? extends HttpChannelFactory> httpChannelFactoryClass = HttpURLConnectionHttpChannelFactory.class;
    private HttpChannelFactory httpChannelFactory;
    private ProxyFactory proxyFactory;
    private String auth;
    private String username;
    private String password;
    private OAuthToken consumerOAuthToken;
    private OAuthToken accessOAuthToken;
    private String accessTokenRefreshUrl;

    public CRest build() {
        CRestBuilder.putIfAbsentAndNotNull(this.crestProperties, DefaultResponseHandler.MIN_ERROR_STATUS_CODE_PROP, 400);
        CRestBuilder.putIfAbsentAndNotNull(this.crestProperties, CRestConfig.class.getName() + "#placeholders", Placeholders.compile(this.placeholders));
        DefaultCRestConfig crestConfig = new DefaultCRestConfig(this.crestProperties);
        ComponentRegistry<String, Deserializer> mimeDeserializerRegistry = this.buildDeserializerRegistry(crestConfig);
        ComponentRegistry<Class<?>, Deserializer> classDeserializerRegistry = this.classDeserializerBuilder.build(crestConfig);
        ComponentRegistry<Class<?>, Serializer> classSerializerRegistry = this.classSerializerBuilder.build(crestConfig);
        DefaultInterfaceConfigBuilderFactory icbf = new DefaultInterfaceConfigBuilderFactory(crestConfig, mimeDeserializerRegistry, classSerializerRegistry);
        DefaultParamConfigBuilderFactory pcbf = new DefaultParamConfigBuilderFactory(crestConfig, classSerializerRegistry);
        CRestBuilder.putIfAbsentAndNotNull(this.crestProperties, ParamConfigBuilderFactory.class.getName(), pcbf);
        ProxyFactory pProxyFactory = CRestBuilder.getInstance(this.proxyFactory, this.proxyFactoryClass, crestConfig);
        HttpChannelFactory plainChannelFactory = CRestBuilder.getInstance(this.httpChannelFactory, this.httpChannelFactoryClass, crestConfig);
        Authorization authorization = this.buildAuthorization(plainChannelFactory);
        CRestBuilder.putIfAbsentAndNotNull(this.crestProperties, Authorization.class.getName(), authorization);
        ResponseDeserializerByMimeType mimeResponseDeserializer = new ResponseDeserializerByMimeType(mimeDeserializerRegistry);
        ResponseDeserializerByClass classResponseDeserializer = new ResponseDeserializerByClass(classDeserializerRegistry);
        ResponseDeserializerByDeserializers deserializersResponseDeserializer = new ResponseDeserializerByDeserializers();
        ResponseDeserializerComposite baseResponseDeserializer = new ResponseDeserializerComposite(deserializersResponseDeserializer, mimeResponseDeserializer, classResponseDeserializer);
        ResponseDeserializerComposite customTypeResponseDeserializer = new ResponseDeserializerComposite(classResponseDeserializer, mimeResponseDeserializer);
        RequestExecutor requestExecutor = this.buildRequestExecutor(plainChannelFactory, authorization, baseResponseDeserializer, customTypeResponseDeserializer);
        if (JaxRsAnnotations.isJaxRsAware()) {
            this.annotationHandlerBuilder.register(JaxRsAnnotations.getMapping());
        }
        AnnotationDrivenInterfaceConfigFactory configFactory = new AnnotationDrivenInterfaceConfigFactory(icbf, this.annotationHandlerBuilder.build(crestConfig));
        return new DefaultCRest(pProxyFactory, requestExecutor, this.requestBuilderFactory, configFactory);
    }

    private static <K, V> void putIfAbsentAndNotNull(Map<K, V> map, K key, V value) {
        if (value == null) {
            return;
        }
        Maps.putIfAbsent(map, key, value);
    }

    private static <T> T getInstance(T defaultIfSet, Class<? extends T> klass, CRestConfig crestConfig) {
        if (defaultIfSet != null) {
            return defaultIfSet;
        }
        try {
            return ComponentFactory.instantiate(klass, crestConfig);
        }
        catch (Exception e) {
            throw CRestException.handle(e);
        }
    }

    private RequestExecutor buildRequestExecutor(HttpChannelFactory plainChannelFactory, Authorization authorization, ResponseDeserializer baseResponseDeserializer, ResponseDeserializer customTypeResponseDeserializer) {
        HttpChannelFactory channelFactory = plainChannelFactory;
        if (authorization != null) {
            channelFactory = new AuthorizationHttpChannelFactory(plainChannelFactory, authorization, this.httpEntityParamExtrators);
        }
        return new RetryingRequestExecutor(new HttpRequestExecutor(channelFactory, baseResponseDeserializer, customTypeResponseDeserializer), 400);
    }

    private ComponentRegistry<String, Deserializer> buildDeserializerRegistry(CRestConfig crestConfig) {
        this.mimeDeserializerBuilder.register((Class<Deserializer>)this.jsonDeserializer, (K[])Arrays.arrify(this.jsonMimes, String.class), this.jsonDeserializerConfig);
        this.mimeDeserializerBuilder.register((Class<Deserializer>)this.xmlDeserializer, (K[])Arrays.arrify(this.xmlMimes, String.class), this.xmlDeserializerConfig);
        this.mimeDeserializerBuilder.register(StringDeserializer.class, (String[])Arrays.arrify(this.plainTextMimes, String.class));
        return this.mimeDeserializerBuilder.build(crestConfig);
    }

    private Authorization buildAuthorization(HttpChannelFactory channelFactory) {
        if ("oauth".equals(this.auth)) {
            return this.buildOAuthorization(channelFactory);
        }
        if ("basic".equals(this.auth)) {
            return this.buildBasicAuthorization();
        }
        return (Authorization)this.crestProperties.get(Authorization.class.getName());
    }

    private Authorization buildBasicAuthorization() {
        return new BasicAuthorization(this.username, this.password);
    }

    private Authorization buildOAuthorization(HttpChannelFactory channelFactory) {
        OAuthenticatorV1 authenticator;
        try {
            authenticator = new OAuthenticatorV1(this.consumerOAuthToken);
        }
        catch (Exception e) {
            throw CRestException.handle(e);
        }
        OAuthApi oAuthApi = this.buildOAuthApi(channelFactory);
        if (oAuthApi == null) {
            return new OAuthorization(this.accessOAuthToken, authenticator);
        }
        return new OAuthorization(this.accessOAuthToken, authenticator, oAuthApi);
    }

    private OAuthApi buildOAuthApi(HttpChannelFactory channelFactory) {
        if (this.accessTokenRefreshUrl == null) {
            return null;
        }
        int indexOfProtocol = this.accessTokenRefreshUrl.indexOf("://") + 3;
        int indexOfServer = this.accessTokenRefreshUrl.indexOf(47, indexOfProtocol);
        String endPoint = this.accessTokenRefreshUrl.substring(0, indexOfServer);
        String path = this.accessTokenRefreshUrl.substring(indexOfServer);
        return new OAuthApiV1Builder(this.consumerOAuthToken, endPoint).refreshAccessTokenFrom(path).using(channelFactory).build();
    }

    public CRestBuilder setProxyFactory(Class<? extends ProxyFactory> proxyFactory) {
        this.proxyFactoryClass = proxyFactory;
        return this;
    }

    public CRestBuilder setProxyFactory(ProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
        return this;
    }

    public CRestBuilder setHttpChannelFactory(Class<? extends HttpChannelFactory> httpChannelFactory) {
        this.httpChannelFactoryClass = httpChannelFactory;
        return this;
    }

    public CRestBuilder setHttpChannelFactory(HttpChannelFactory httpChannelFactory) {
        this.httpChannelFactory = httpChannelFactory;
        return this;
    }

    public CRestBuilder setConcurrencyLevel(int concurrencyLevel) {
        return this.property(CRestConfig.CREST_CONCURRENCY_LEVEL, concurrencyLevel);
    }

    public CRestBuilder dateFormat(String dateFormat) {
        return this.property(CRestConfig.CREST_DATE_FORMAT, dateFormat);
    }

    public CRestBuilder booleanFormat(String trueFormat, String falseFormat) {
        return this.property(CRestConfig.CREST_BOOLEAN_TRUE, trueFormat).property(CRestConfig.CREST_BOOLEAN_FALSE, falseFormat);
    }

    public CRestBuilder addProperties(Map<String, Object> crestProperties) {
        this.crestProperties.putAll(crestProperties);
        return this;
    }

    public CRestBuilder property(String name, Object value) {
        return this.addProperties(java.util.Collections.singletonMap(name, value));
    }

    public CRestBuilder setProperties(Map<String, Object> crestProperties) {
        this.crestProperties.clear();
        return this.addProperties(crestProperties);
    }

    public CRestBuilder endpoint(String endpoint) {
        return this.property(MethodConfig.METHOD_CONFIG_DEFAULT_ENDPOINT, endpoint);
    }

    public CRestBuilder addPlaceholders(Map<String, String> placeholders) {
        this.placeholders.putAll(placeholders);
        return this;
    }

    public CRestBuilder placeholder(String placeholder, String value) {
        return this.addPlaceholders(java.util.Collections.singletonMap(placeholder, value));
    }

    public CRestBuilder setPlaceholders(Map<String, String> placeholders) {
        this.placeholders.clear();
        return this.addPlaceholders(placeholders);
    }

    public <A extends Annotation> CRestBuilder bindAnnotationHandler(Class<? extends AnnotationHandler<A>> handler, Class<A> annotationCls) {
        return this.bindAnnotationHandler(handler, annotationCls, java.util.Collections.<String, Object>emptyMap());
    }

    public <A extends Annotation> CRestBuilder bindAnnotationHandler(Class<? extends AnnotationHandler<A>> handler, Class<A> annotationCls, Map<String, Object> config) {
        this.annotationHandlerBuilder.register((Class<AnnotationHandler>)handler, (K[])new Class[]{annotationCls}, config);
        return this;
    }

    public CRestBuilder bindDeserializer(Class<? extends Deserializer> deserializer, String ... mimeTypes) {
        return this.bindDeserializer(deserializer, mimeTypes, java.util.Collections.<String, Object>emptyMap());
    }

    public CRestBuilder bindDeserializer(Class<? extends Deserializer> deserializer, String[] mimeTypes, Map<String, Object> config) {
        this.mimeDeserializerBuilder.register((Class<Deserializer>)deserializer, (K[])mimeTypes, config);
        return this;
    }

    public CRestBuilder bindDeserializer(Class<? extends Deserializer> deserializer, Class<?> ... classes) {
        return this.bindDeserializer(deserializer, classes, java.util.Collections.<String, Object>emptyMap());
    }

    public CRestBuilder bindDeserializer(Class<? extends Deserializer> deserializer, Class<?>[] classes, Map<String, Object> config) {
        this.classDeserializerBuilder.register((Class<Deserializer>)deserializer, (K[])classes, config);
        return this;
    }

    public CRestBuilder bindSerializer(Class<? extends Serializer> serializer, Class<?> ... classes) {
        return this.bindSerializer(serializer, classes, java.util.Collections.<String, Object>emptyMap());
    }

    public CRestBuilder bindSerializer(Class<? extends Serializer> serializer, Class<?>[] classes, Map<String, Object> config) {
        this.classSerializerBuilder.register((Class<Serializer>)serializer, (K[])classes, config);
        return this;
    }

    public CRestBuilder oauth(String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret) {
        return this.oauth(consumerKey, consumerSecret, accessToken, accessTokenSecret, null, null);
    }

    public CRestBuilder oauth(String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret, String sessionHandle, String accessTokenRefreshUrl) {
        this.auth = "oauth";
        this.accessOAuthToken = sessionHandle != null ? new OAuthToken(accessToken, accessTokenSecret, java.util.Collections.singletonMap("oauth_session_handle", sessionHandle)) : new OAuthToken(accessToken, accessTokenSecret);
        if (accessTokenRefreshUrl != null) {
            this.property(MethodConfig.METHOD_CONFIG_DEFAULT_RETRY_HANDLER, RefreshAuthorizationRetryHandler.class);
            this.property(RefreshAuthorizationRetryHandler.UNAUTHORIZED_STATUS_CODE_PROP, 401);
        }
        this.accessTokenRefreshUrl = accessTokenRefreshUrl;
        this.consumerOAuthToken = new OAuthToken(consumerKey, consumerSecret);
        return this;
    }

    public CRestBuilder basicAuth(String username, String password) {
        this.auth = "basic";
        this.username = username;
        this.password = password;
        return this;
    }

    public CRestBuilder extractsEntityAuthParamsWith(String entityContentType, EntityParamExtractor entityParamExtractor) {
        this.httpEntityParamExtrators.put(entityContentType, entityParamExtractor);
        return this;
    }

    public CRestBuilder bindJsonDeserializerWith(String ... mimeTypes) {
        this.jsonMimes.addAll(Collections.asSet(mimeTypes));
        return this;
    }

    public CRestBuilder bindXmlDeserializerWith(String ... mimeTypes) {
        this.xmlMimes.addAll(Collections.asSet(mimeTypes));
        return this;
    }

    public CRestBuilder bindPlainTextDeserializerWith(String ... mimeTypes) {
        this.plainTextMimes.addAll(Collections.asSet(mimeTypes));
        return this;
    }

    public CRestBuilder deserializeXmlWith(Class<? extends Deserializer> deserializer) {
        return this.deserializeXmlWith(deserializer, java.util.Collections.<String, Object>emptyMap());
    }

    public CRestBuilder deserializeXmlWith(Class<? extends Deserializer> deserializer, Map<String, Object> config) {
        this.xmlDeserializer = deserializer;
        this.xmlDeserializerConfig.clear();
        this.xmlDeserializerConfig.putAll(config);
        return this;
    }

    public CRestBuilder deserializeJsonWith(Class<? extends Deserializer> deserializer) {
        return this.deserializeJsonWith(deserializer, java.util.Collections.<String, Object>emptyMap());
    }

    public CRestBuilder deserializeJsonWith(Class<? extends Deserializer> deserializer, Map<String, Object> config) {
        this.jsonDeserializer = deserializer;
        this.jsonDeserializerConfig.clear();
        this.jsonDeserializerConfig.putAll(config);
        return this;
    }
}

