/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.crest;

import java.util.Map;
import org.codegist.crest.CRestBuilder;
import org.codegist.crest.CRestException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CRest {
    public abstract <T> T build(Class<T> var1) throws CRestException;

    public static CRest getInstance() {
        return new CRestBuilder().build();
    }

    public static CRest getInstance(String endpoint) {
        return CRest.endpoint(endpoint).build();
    }

    public static CRest getInstance(Map<String, String> placeholders) {
        return CRest.placeholders(placeholders).build();
    }

    public static CRest getOAuthInstance(String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret) {
        return CRest.oauth(consumerKey, consumerSecret, accessToken, accessTokenSecret).build();
    }

    public static CRest getOAuthInstance(String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret, String sessionHandle, String accessTokenRefreshUrl) {
        return CRest.oauth(consumerKey, consumerSecret, accessToken, accessTokenSecret, sessionHandle, accessTokenRefreshUrl).build();
    }

    public static CRest getBasicAuthInstance(String username, String password) {
        return CRest.basicAuth(username, password).build();
    }

    public static CRestBuilder endpoint(String endpoint) {
        return new CRestBuilder().endpoint(endpoint);
    }

    public static CRestBuilder property(String name, Object value) {
        return new CRestBuilder().property(name, value);
    }

    public static CRestBuilder placeholder(String placeholder, String value) {
        return new CRestBuilder().placeholder(placeholder, value);
    }

    public static CRestBuilder placeholders(Map<String, String> placeholders) {
        return new CRestBuilder().setPlaceholders(placeholders);
    }

    public static CRestBuilder oauth(String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret) {
        return new CRestBuilder().oauth(consumerKey, consumerSecret, accessToken, accessTokenSecret);
    }

    public static CRestBuilder oauth(String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret, String sessionHandle, String accessTokenRefreshUrl) {
        return new CRestBuilder().oauth(consumerKey, consumerSecret, accessToken, accessTokenSecret, sessionHandle, accessTokenRefreshUrl);
    }

    public static CRestBuilder basicAuth(String username, String password) {
        return new CRestBuilder().basicAuth(username, password);
    }
}

