/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.common.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.codegist.common.reflect.ParameterizedTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Types {
    private Types() {
        throw new IllegalStateException();
    }

    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return Types.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = Types.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    public static Class<?> getComponentClass(Class<?> clazz, Type genericType) {
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Type typeArg = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            return Types.getClass(typeArg);
        }
        if (genericType instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)genericType).getGenericComponentType();
            Class<?> componentClass = Types.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return clazz;
    }

    public static Type getComponentType(Class<?> clazz, Type genericType) {
        if (Collection.class.isAssignableFrom(clazz)) {
            return ((ParameterizedType)genericType).getActualTypeArguments()[0];
        }
        if (genericType instanceof GenericArrayType) {
            return ((GenericArrayType)genericType).getGenericComponentType();
        }
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        return genericType;
    }

    public static Set<Class<?>> getActors(Type type) {
        HashSet classes = new HashSet();
        Types.fillClasses(type, classes);
        return classes;
    }

    private static void fillClasses(Type type, Set<Class<?>> classes) {
        Class<?> clazz = Types.getClass(type);
        if (clazz != null) {
            classes.add(clazz);
        }
        if (type instanceof ParameterizedType) {
            for (Type t : ((ParameterizedType)type).getActualTypeArguments()) {
                Types.fillClasses(t, classes);
            }
        } else if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Types.fillClasses(componentType, classes);
        }
    }

    public static ParameterizedType newType(Class<?> holder, Type ... actualTypeArguments) {
        return Types.newType(holder, actualTypeArguments, null);
    }

    public static ParameterizedType newType(Class<?> holder, Type[] actualTypeArguments, Type ownerType) {
        return new ParameterizedTypeImpl(holder, actualTypeArguments, ownerType);
    }
}

