/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.common.log;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Date;
import org.codegist.common.log.AbstractLogger;

public class StdOutLogger
extends AbstractLogger
implements Serializable {
    private static final String FORMAT = "%tc [%5s] - %s: %s\n";
    private final String name;
    private final transient PrintWriter out;

    public StdOutLogger(String name) {
        this(new PrintWriter(System.out), name);
    }

    public StdOutLogger(PrintWriter out, String name) {
        this.out = out;
        this.name = name;
    }

    private void log(String lvl, Object message, Throwable error) {
        String msg = message != null ? message.toString().replaceAll("%", "%%") : null;
        this.out.format(String.format(FORMAT, new Date().getTime(), lvl, this.name, msg), new Object[0]);
        if (error != null) {
            error.printStackTrace(this.out);
        }
        this.out.flush();
    }

    protected void logError(Object message, Throwable e) {
        this.log("ERROR", message, e);
    }

    protected void logError(Object message) {
        this.logError(message, null);
    }

    protected void logWarn(Object message, Throwable e) {
        this.log("WARN", message, e);
    }

    protected void logWarn(Object message) {
        this.logWarn(message, null);
    }

    protected void logInfo(Object message, Throwable e) {
        this.log("INFO", message, e);
    }

    protected void logInfo(Object message) {
        this.logInfo(message, null);
    }

    protected void logDebug(Object message, Throwable e) {
        this.log("DEBUG", message, e);
    }

    protected void logDebug(Object message) {
        this.logDebug(message, null);
    }

    protected void logTrace(Object message, Throwable e) {
        this.log("TRACE", message, e);
    }

    protected void logTrace(Object message) {
        this.logTrace(message, null);
    }

    public boolean isErrorOn() {
        return true;
    }

    public boolean isWarnOn() {
        return true;
    }

    public boolean isInfoOn() {
        return true;
    }

    public boolean isDebugOn() {
        return true;
    }

    public boolean isTraceOn() {
        return true;
    }
}

