/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.common.log;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import org.codegist.common.log.Logger;

public class LoggingOutputStream
extends OutputStream {
    private final StringWriter sw = new StringWriter();
    private final OutputStream delegate;
    private final Logger logger;

    public LoggingOutputStream(OutputStream delegate, Logger logger) {
        this.delegate = delegate;
        this.logger = logger;
    }

    public void write(int b) throws IOException {
        this.delegate.write(b);
        this.sw.append((char)b);
    }

    public void write(byte[] b) throws IOException {
        this.delegate.write(b);
        this.sw.append(new String(b));
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
        this.sw.append(new String(b, off, len));
    }

    public void flush() throws IOException {
        this.delegate.flush();
        this.logger.trace("\n" + this.sw);
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

