/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.common.log;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.codegist.common.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LoggerFactory {
    private final Map<String, Reference<Logger>> flyweight;
    private final Class<? extends Logger> loggerCls;

    public LoggerFactory(Map<String, Reference<Logger>> flyweight, Class<? extends Logger> loggerCls) {
        this.flyweight = flyweight;
        this.loggerCls = loggerCls;
    }

    public LoggerFactory(Class<? extends Logger> loggerCls) {
        this(new HashMap<String, Reference<Logger>>(), loggerCls);
    }

    public Logger getLogger(Class<?> clazz) {
        return this.getLogger(clazz.getName());
    }

    public Logger getLogger(String name) {
        Logger logger;
        Reference<Logger> loggerRef = this.flyweight.get(name);
        Logger logger2 = logger = loggerRef != null ? loggerRef.get() : null;
        if (logger == null) {
            try {
                logger = this.loggerCls.getConstructor(String.class).newInstance(name);
            }
            catch (Exception retry) {
                try {
                    logger = this.loggerCls.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.flyweight.put(name, new SoftReference<Logger>(logger));
        }
        return logger;
    }
}

