/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.common.log;

import android.util.Log;
import java.io.Serializable;
import org.codegist.common.log.AbstractLogger;

public class LogCatLogger
extends AbstractLogger
implements Serializable {
    static final String LOGGER_TAG = LogCatLogger.class.getName() + ".TAG";
    private static final String TAG = System.getProperty(LOGGER_TAG, "CodeGist");
    private final String name;

    public LogCatLogger(String name) {
        this.name = name;
    }

    private String msg(Object o) {
        return String.format("%s: %s", this.name, o);
    }

    protected void logError(Object message, Throwable e) {
        Log.e((String)TAG, (String)this.msg(message), (Throwable)e);
    }

    protected void logError(Object message) {
        Log.e((String)TAG, (String)this.msg(message));
    }

    protected void logWarn(Object message, Throwable e) {
        Log.w((String)TAG, (String)this.msg(message), (Throwable)e);
    }

    protected void logWarn(Object message) {
        Log.w((String)TAG, (String)this.msg(message));
    }

    protected void logInfo(Object message, Throwable e) {
        Log.i((String)TAG, (String)this.msg(message), (Throwable)e);
    }

    protected void logInfo(Object message) {
        Log.i((String)TAG, (String)this.msg(message));
    }

    protected void logDebug(Object message, Throwable e) {
        Log.d((String)TAG, (String)this.msg(message), (Throwable)e);
    }

    protected void logDebug(Object message) {
        Log.d((String)TAG, (String)this.msg(message));
    }

    protected void logTrace(Object message, Throwable e) {
        Log.v((String)TAG, (String)this.msg(message), (Throwable)e);
    }

    protected void logTrace(Object message) {
        Log.v((String)TAG, (String)this.msg(message));
    }

    public boolean isErrorOn() {
        return Log.isLoggable((String)TAG, (int)6);
    }

    public boolean isWarnOn() {
        return Log.isLoggable((String)TAG, (int)5);
    }

    public boolean isInfoOn() {
        return Log.isLoggable((String)TAG, (int)4);
    }

    public boolean isDebugOn() {
        return Log.isLoggable((String)TAG, (int)3);
    }

    public boolean isTraceOn() {
        return Log.isLoggable((String)TAG, (int)2);
    }
}

