/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.common.collect;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Maps {
    private Maps() {
        throw new IllegalStateException();
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, K ... filterKeys) {
        HashMap<K, V> filtered = new HashMap<K, V>();
        List<K> filter = Arrays.asList(filterKeys);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (filter.contains(entry.getKey())) continue;
            filtered.put(entry.getKey(), entry.getValue());
        }
        return filtered;
    }

    public static <K, V> boolean putIfAbsent(Map<K, V> map, K key, V value) {
        if (map.containsKey(key)) {
            return false;
        }
        map.put(key, value);
        return true;
    }

    public static <K, V> Map<K, V> merge(Map<K, V> ... maps) {
        HashMap<K, V> merged = new HashMap<K, V>();
        for (Map<K, V> map : maps) {
            merged.putAll(map);
        }
        return merged;
    }
}

