/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.common.collect;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Collections {
    public static final Iterator EMPTY_ITERATOR = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    private Collections() {
        throw new IllegalStateException();
    }

    public static <T> String join(String sep, Collection<T> items) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int max = items.size();
        for (T s : items) {
            sb.append(s);
            if (++i >= max) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public static <T> Set<T> asSet(T ... values) {
        return new HashSet<T>(Arrays.asList(values));
    }

    public static <T> boolean containsOnlyNulls(Collection<T> collection) {
        for (T v : collection) {
            if (v == null) continue;
            return false;
        }
        return true;
    }
}

