/*
 * Decompiled with CFR 0.152.
 */
package org.codegist.common.collect;

import java.lang.reflect.Array;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Arrays {
    private Arrays() {
        throw new IllegalStateException();
    }

    public static <T> T[] merge(Class<T> cls, T[] ... arrays) {
        int totalLength = 0;
        for (T[] arr : arrays) {
            totalLength += arr.length;
        }
        Object[] merge = (Object[])Array.newInstance(cls, totalLength);
        int pos = 0;
        for (T[] arr : arrays) {
            System.arraycopy(arr, 0, merge, pos, arr.length);
            pos += arr.length;
        }
        return merge;
    }

    public static <T> String join(String sep, T ... items) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int max = items.length;
        for (T s : items) {
            sb.append(s);
            if (++i >= max) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public static <T> T[] arrify(Collection<T> collection, Class<T> clazz) {
        return collection.toArray((Object[])Array.newInstance(clazz, collection.size()));
    }
}

