/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.model.User;
import io.jenkins.plugins.mcp.server.Endpoint;
import io.modelcontextprotocol.spec.McpSchema;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class UserContextHttpRequest
extends HttpServletRequestWrapper {
    private final byte[] requestBody;

    public UserContextHttpRequest(ObjectMapper objectMapper, HttpServletRequest request) throws IOException {
        super(request);
        McpSchema.JSONRPCRequest jsonrpcRequest;
        McpSchema.JSONRPCMessage message;
        String line;
        BufferedReader reader = request.getReader();
        StringBuilder body = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            body.append(line);
        }
        String bodyString = body.toString().trim();
        if (!bodyString.isEmpty() && (message = McpSchema.deserializeJsonRpcMessage((ObjectMapper)objectMapper, (String)bodyString)) instanceof McpSchema.JSONRPCRequest && (jsonrpcRequest = (McpSchema.JSONRPCRequest)message).method().equals("tools/call")) {
            Object object;
            User currentUser = User.current();
            String userId = null;
            if (currentUser != null) {
                userId = currentUser.getId();
            }
            if ((object = jsonrpcRequest.params()) instanceof Map) {
                Map params = (Map)object;
                if (userId != null) {
                    Map meta = params.getOrDefault("_meta", new HashMap());
                    meta.put(Endpoint.USER_ID, userId);
                    params.put("_meta", meta);
                    bodyString = objectMapper.writeValueAsString((Object)jsonrpcRequest);
                }
            }
        }
        this.requestBody = bodyString.isEmpty() ? new byte[0] : (request.getCharacterEncoding() != null ? bodyString.getBytes(request.getCharacterEncoding()) : bodyString.getBytes(StandardCharsets.ISO_8859_1));
    }

    public ServletInputStream getInputStream() {
        final ByteArrayInputStream bais = new ByteArrayInputStream(this.requestBody);
        return new ServletInputStream(){

            public int read() {
                return bais.read();
            }

            public boolean isFinished() {
                return bais.available() == 0;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.getCharacterEncoding()));
    }
}

