/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import io.modelcontextprotocol.server.McpTransportContext;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class McpStatelessServerFeatures {

    public record SyncCompletionSpecification(McpSchema.CompleteReference referenceKey, BiFunction<McpTransportContext, McpSchema.CompleteRequest, McpSchema.CompleteResult> completionHandler) {
    }

    public record SyncPromptSpecification(McpSchema.Prompt prompt, BiFunction<McpTransportContext, McpSchema.GetPromptRequest, McpSchema.GetPromptResult> promptHandler) {
    }

    public record SyncResourceSpecification(McpSchema.Resource resource, BiFunction<McpTransportContext, McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> readHandler) {
    }

    public record SyncToolSpecification(McpSchema.Tool tool, BiFunction<McpTransportContext, McpSchema.CallToolRequest, McpSchema.CallToolResult> callHandler) {
        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private McpSchema.Tool tool;
            private BiFunction<McpTransportContext, McpSchema.CallToolRequest, McpSchema.CallToolResult> callHandler;

            public Builder tool(McpSchema.Tool tool) {
                this.tool = tool;
                return this;
            }

            public Builder callHandler(BiFunction<McpTransportContext, McpSchema.CallToolRequest, McpSchema.CallToolResult> callHandler) {
                this.callHandler = callHandler;
                return this;
            }

            public SyncToolSpecification build() {
                Assert.notNull(this.tool, "Tool must not be null");
                Assert.notNull(this.callHandler, "CallTool function must not be null");
                return new SyncToolSpecification(this.tool, this.callHandler);
            }
        }
    }

    public record AsyncCompletionSpecification(McpSchema.CompleteReference referenceKey, BiFunction<McpTransportContext, McpSchema.CompleteRequest, Mono<McpSchema.CompleteResult>> completionHandler) {
        static AsyncCompletionSpecification fromSync(SyncCompletionSpecification completion, boolean immediateExecution) {
            if (completion == null) {
                return null;
            }
            return new AsyncCompletionSpecification(completion.referenceKey(), (ctx, req) -> {
                Mono completionResult = Mono.fromCallable(() -> completion.completionHandler().apply((McpTransportContext)ctx, (McpSchema.CompleteRequest)req));
                return immediateExecution ? completionResult : completionResult.subscribeOn(Schedulers.boundedElastic());
            });
        }
    }

    public record AsyncPromptSpecification(McpSchema.Prompt prompt, BiFunction<McpTransportContext, McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> promptHandler) {
        static AsyncPromptSpecification fromSync(SyncPromptSpecification prompt, boolean immediateExecution) {
            if (prompt == null) {
                return null;
            }
            return new AsyncPromptSpecification(prompt.prompt(), (ctx, req) -> {
                Mono promptResult = Mono.fromCallable(() -> prompt.promptHandler().apply((McpTransportContext)ctx, (McpSchema.GetPromptRequest)req));
                return immediateExecution ? promptResult : promptResult.subscribeOn(Schedulers.boundedElastic());
            });
        }
    }

    public record AsyncResourceSpecification(McpSchema.Resource resource, BiFunction<McpTransportContext, McpSchema.ReadResourceRequest, Mono<McpSchema.ReadResourceResult>> readHandler) {
        static AsyncResourceSpecification fromSync(SyncResourceSpecification resource, boolean immediateExecution) {
            if (resource == null) {
                return null;
            }
            return new AsyncResourceSpecification(resource.resource(), (ctx, req) -> {
                Mono resourceResult = Mono.fromCallable(() -> resource.readHandler().apply((McpTransportContext)ctx, (McpSchema.ReadResourceRequest)req));
                return immediateExecution ? resourceResult : resourceResult.subscribeOn(Schedulers.boundedElastic());
            });
        }
    }

    public record AsyncToolSpecification(McpSchema.Tool tool, BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> callHandler) {
        static AsyncToolSpecification fromSync(SyncToolSpecification syncToolSpec) {
            return AsyncToolSpecification.fromSync(syncToolSpec, false);
        }

        static AsyncToolSpecification fromSync(SyncToolSpecification syncToolSpec, boolean immediate) {
            if (syncToolSpec == null) {
                return null;
            }
            BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> callHandler = (ctx, req) -> {
                Mono toolResult = Mono.fromCallable(() -> syncToolSpec.callHandler().apply((McpTransportContext)ctx, (McpSchema.CallToolRequest)req));
                return immediate ? toolResult : toolResult.subscribeOn(Schedulers.boundedElastic());
            };
            return new AsyncToolSpecification(syncToolSpec.tool(), callHandler);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private McpSchema.Tool tool;
            private BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> callHandler;

            public Builder tool(McpSchema.Tool tool) {
                this.tool = tool;
                return this;
            }

            public Builder callHandler(BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> callHandler) {
                this.callHandler = callHandler;
                return this;
            }

            public AsyncToolSpecification build() {
                Assert.notNull(this.tool, "Tool must not be null");
                Assert.notNull(this.callHandler, "Call handler function must not be null");
                return new AsyncToolSpecification(this.tool, this.callHandler);
            }
        }
    }

    record Sync(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<SyncToolSpecification> tools, Map<String, SyncResourceSpecification> resources, List<McpSchema.ResourceTemplate> resourceTemplates, Map<String, SyncPromptSpecification> prompts, Map<McpSchema.CompleteReference, SyncCompletionSpecification> completions, String instructions) {
        Sync(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<SyncToolSpecification> tools, Map<String, SyncResourceSpecification> resources, List<McpSchema.ResourceTemplate> resourceTemplates, Map<String, SyncPromptSpecification> prompts, Map<McpSchema.CompleteReference, SyncCompletionSpecification> completions, String instructions) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            this.serverCapabilities = serverCapabilities != null ? serverCapabilities : new McpSchema.ServerCapabilities(null, null, new McpSchema.ServerCapabilities.LoggingCapabilities(), !Utils.isEmpty(prompts) ? new McpSchema.ServerCapabilities.PromptCapabilities(false) : null, !Utils.isEmpty(resources) ? new McpSchema.ServerCapabilities.ResourceCapabilities(false, false) : null, !Utils.isEmpty(tools) ? new McpSchema.ServerCapabilities.ToolCapabilities(false) : null);
            this.tools = tools != null ? tools : new ArrayList();
            this.resources = resources != null ? resources : new HashMap();
            this.resourceTemplates = resourceTemplates != null ? resourceTemplates : new ArrayList();
            this.prompts = prompts != null ? prompts : new HashMap();
            this.completions = completions != null ? completions : new HashMap();
            this.instructions = instructions;
        }
    }

    record Async(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<AsyncToolSpecification> tools, Map<String, AsyncResourceSpecification> resources, List<McpSchema.ResourceTemplate> resourceTemplates, Map<String, AsyncPromptSpecification> prompts, Map<McpSchema.CompleteReference, AsyncCompletionSpecification> completions, String instructions) {
        Async(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<AsyncToolSpecification> tools, Map<String, AsyncResourceSpecification> resources, List<McpSchema.ResourceTemplate> resourceTemplates, Map<String, AsyncPromptSpecification> prompts, Map<McpSchema.CompleteReference, AsyncCompletionSpecification> completions, String instructions) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            this.serverCapabilities = serverCapabilities != null ? serverCapabilities : new McpSchema.ServerCapabilities(null, null, new McpSchema.ServerCapabilities.LoggingCapabilities(), !Utils.isEmpty(prompts) ? new McpSchema.ServerCapabilities.PromptCapabilities(false) : null, !Utils.isEmpty(resources) ? new McpSchema.ServerCapabilities.ResourceCapabilities(false, false) : null, !Utils.isEmpty(tools) ? new McpSchema.ServerCapabilities.ToolCapabilities(false) : null);
            this.tools = tools != null ? tools : List.of();
            this.resources = resources != null ? resources : Map.of();
            this.resourceTemplates = resourceTemplates != null ? resourceTemplates : List.of();
            this.prompts = prompts != null ? prompts : Map.of();
            this.completions = completions != null ? completions : Map.of();
            this.instructions = instructions;
        }

        static Async fromSync(Sync syncSpec, boolean immediateExecution) {
            ArrayList<AsyncToolSpecification> tools = new ArrayList<AsyncToolSpecification>();
            for (SyncToolSpecification tool : syncSpec.tools()) {
                tools.add(AsyncToolSpecification.fromSync(tool, immediateExecution));
            }
            HashMap<String, AsyncResourceSpecification> resources = new HashMap<String, AsyncResourceSpecification>();
            syncSpec.resources().forEach((key, resource) -> resources.put((String)key, AsyncResourceSpecification.fromSync(resource, immediateExecution)));
            HashMap<String, AsyncPromptSpecification> prompts = new HashMap<String, AsyncPromptSpecification>();
            syncSpec.prompts().forEach((key, prompt) -> prompts.put((String)key, AsyncPromptSpecification.fromSync(prompt, immediateExecution)));
            HashMap<McpSchema.CompleteReference, AsyncCompletionSpecification> completions = new HashMap<McpSchema.CompleteReference, AsyncCompletionSpecification>();
            syncSpec.completions().forEach((key, completion) -> completions.put((McpSchema.CompleteReference)key, AsyncCompletionSpecification.fromSync(completion, immediateExecution)));
            return new Async(syncSpec.serverInfo(), syncSpec.serverCapabilities(), tools, resources, syncSpec.resourceTemplates(), prompts, completions, syncSpec.instructions());
        }
    }
}

