/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server.extensions;

import hudson.Extension;
import hudson.PluginWrapper;
import hudson.model.Job;
import io.jenkins.plugins.mcp.server.McpServerExtension;
import io.jenkins.plugins.mcp.server.annotation.Tool;
import io.jenkins.plugins.mcp.server.annotation.ToolParam;
import io.jenkins.plugins.mcp.server.extensions.scm.GitScmConfig;
import io.jenkins.plugins.mcp.server.extensions.scm.GitScmUtil;
import io.jenkins.plugins.mcp.server.extensions.util.JenkinsUtil;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import jenkins.model.Jenkins;
import jenkins.scm.RunWithSCM;
import jenkins.triggers.SCMTriggerItem;

@Extension
public class JobScmExtension
implements McpServerExtension {
    public static boolean isGitPluginInstalled() {
        PluginWrapper gitPlugin = Jenkins.get().getPluginManager().getPlugin("git");
        return gitPlugin != null && gitPlugin.isActive();
    }

    @Tool(description="Retrieves scm configurations of a Jenkins job", annotations=@Tool.Annotations(destructiveHint=false))
    public List getJobScm(@ToolParam(description="Full path of the Jenkins job (e.g., 'folder/job-name')") String jobFullName) {
        Job job = (Job)Jenkins.get().getItemByFullName(jobFullName, Job.class);
        if (job instanceof SCMTriggerItem) {
            SCMTriggerItem scmItem = (SCMTriggerItem)job;
            return scmItem.getSCMs().stream().map(scm -> {
                GitScmConfig result = null;
                if (scm.getType().equals("hudson.plugins.git.GitSCM")) {
                    result = GitScmUtil.extractGitScmInfo(scm);
                }
                return result;
            }).filter(Objects::nonNull).toList();
        }
        return List.of();
    }

    @Tool(description="Retrieves scm configurations of a Jenkins build", annotations=@Tool.Annotations(destructiveHint=false))
    public List getBuildScm(@ToolParam(description="Full path of the Jenkins job (e.g., 'folder/job-name')") String jobFullName, @Nullable @ToolParam(description="Build number (optional, if not provided, updates the last build)", required=false) Integer buildNumber) {
        return JenkinsUtil.getBuildByNumberOrLast(jobFullName, buildNumber).map(build -> {
            if (JobScmExtension.isGitPluginInstalled()) {
                return List.of(GitScmUtil.extractGitScmInfo(build));
            }
            return List.of();
        }).orElse(List.of());
    }

    @Tool(description="Retrieves change log sets of a Jenkins build", annotations=@Tool.Annotations(destructiveHint=false))
    public List getBuildChangeSets(@ToolParam(description="Full path of the Jenkins job (e.g., 'folder/job-name')") String jobFullName, @Nullable @ToolParam(description="Build number (optional, if not provided, updates the last build)", required=false) Integer buildNumber) {
        return JenkinsUtil.getBuildByNumberOrLast(jobFullName, buildNumber).filter(RunWithSCM.class::isInstance).map(RunWithSCM.class::cast).map(RunWithSCM::getChangeSets).orElse(List.of());
    }
}

