/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.keyword.KeywordValidator;
import com.networknt.schema.path.NodePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DependentRequired
extends BaseKeywordValidator
implements KeywordValidator {
    private final Map<String, List<String>> propertyDependencies = new HashMap<String, List<String>>();

    public DependentRequired(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.DEPENDENT_REQUIRED, schemaNode, schemaLocation, parentSchema, schemaContext);
        Iterator it = schemaNode.fieldNames();
        while (it.hasNext()) {
            String pname = (String)it.next();
            JsonNode pvalue = schemaNode.get(pname);
            if (!pvalue.isArray()) continue;
            List dependencies = this.propertyDependencies.computeIfAbsent(pname, k -> new ArrayList());
            for (int i = 0; i < pvalue.size(); ++i) {
                dependencies.add(pvalue.get(i).asText());
            }
        }
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            String pname = (String)it.next();
            List<String> dependencies = this.propertyDependencies.get(pname);
            if (dependencies == null || dependencies.isEmpty()) continue;
            for (String field : dependencies) {
                if (node.get(field) != null) continue;
                executionContext.addError(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(node)).property(pname)).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).locale(executionContext.getExecutionConfig().getLocale())).arguments(field, pname)).build());
            }
        }
    }
}

