/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.format;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.Format;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;

public class DateFormat
implements Format {
    @Override
    public boolean matches(ExecutionContext executionContext, String value) {
        try {
            LocalDate date = LocalDate.parse(value);
            int year = date.getYear();
            return 0 <= year && year <= 9999;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    @Override
    public String getName() {
        return "date";
    }

    @Override
    public String getMessageKey() {
        return "format.date";
    }
}

