/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.maven_artifact_choicelistprovider.central;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.IVersionReader;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.ValidAndInvalidClassifier;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.VersionReaderException;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.central.MavenCentralResponseModel;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.central.MavenCentralResponseParser;
import org.jenkinsci.plugins.maven_artifact_choicelistprovider.central.ResponseDoc;

public class MavenCentralSearchService
implements IVersionReader {
    public static final String REPO_RETRIEVE_URL = "https://repo1.maven.org/maven2/";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String REPO_SEARCH_SERVICE_URL = "http://search.maven.org/solrsearch/";
    private static final Logger LOGGER = Logger.getLogger(MavenCentralSearchService.class.getName());
    private static final String USER_AGENT = "Mozilla/5.0";
    private static final int MAX_SEARCH_RESULTS = 100;

    @Override
    public List<String> retrieveVersions(String pRepositoryId, String pGroupId, String pArtifactId, String pPackaging, ValidAndInvalidClassifier pClassifier) throws VersionReaderException {
        try {
            String targetURL = this.createURL(pGroupId, pArtifactId, pPackaging, pClassifier);
            LOGGER.fine("target url:" + targetURL);
            String response = this.sendAndReceive(targetURL.toString());
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest(response);
            }
            MavenCentralResponseModel responseObj = MavenCentralResponseParser.parse(response);
            LinkedHashSet<String> retVal = new LinkedHashSet<String>();
            if (this.containsResponses(responseObj)) {
                for (ResponseDoc current : responseObj.getResponse().getDocs()) {
                    retVal.addAll(this.createItemURLs(current, pPackaging));
                }
            }
            return new ArrayList<String>(retVal);
        }
        catch (VersionReaderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VersionReaderException("failed to retrieve versions from maven-central for r:" + this.getSearchURL() + ", g:" + pGroupId + ", a:" + pArtifactId + ", p:" + pPackaging + ", c:" + String.valueOf(pClassifier) + e.getMessage(), e);
        }
    }

    List<String> createItemURLs(ResponseDoc pResponseEntry, String pRequestedPackaging) {
        ArrayList<String> retVal = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRetrieveURL());
        sb.append(pResponseEntry.getGroupId().replace(".", "/")).append("/");
        sb.append(pResponseEntry.getArtifactId()).append("/");
        sb.append(pResponseEntry.getVersion()).append("/");
        sb.append(pResponseEntry.getArtifactId()).append("-");
        sb.append(pResponseEntry.getVersion());
        for (String currentEC : pResponseEntry.getEc()) {
            if (this.validPackaging(currentEC, pRequestedPackaging)) {
                retVal.add(sb.toString() + currentEC);
                continue;
            }
            LOGGER.fine("ignoring packaging '" + currentEC + "', accepted is: '" + pRequestedPackaging + "'");
        }
        return retVal;
    }

    boolean validPackaging(String pCurrentPackaging, String pRequestedPackaging) {
        if (StringUtils.isEmpty((String)pRequestedPackaging.trim())) {
            return true;
        }
        return pCurrentPackaging.equalsIgnoreCase("." + pRequestedPackaging);
    }

    boolean containsResponses(MavenCentralResponseModel pResponse) {
        if (pResponse == null) {
            return false;
        }
        if (pResponse.getResponse() == null) {
            return false;
        }
        if (pResponse.getResponse().getDocs() == null) {
            return false;
        }
        return pResponse.getResponse().getDocs().length > 0;
    }

    String sendAndReceive(String pURL) throws VersionReaderException {
        try {
            String inputLine;
            URL obj = new URL(pURL.toString());
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("User-Agent", USER_AGENT);
            int responseCode = con.getResponseCode();
            if (200 != responseCode) {
                throw new VersionReaderException("server replied with an error: " + responseCode);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream(), UTF8));
            StringBuffer retVal = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                retVal.append(inputLine);
            }
            in.close();
            return retVal.toString();
        }
        catch (VersionReaderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VersionReaderException("general error while retrieving versions from url " + pURL, e);
        }
    }

    private String createURL(String pGroupId, String pArtifactId, String pPackaging, ValidAndInvalidClassifier pClassifier) {
        StringBuilder targetURL = new StringBuilder();
        targetURL.append(this.getSearchURL());
        targetURL.append("select?q=");
        if (!"".equals(pGroupId)) {
            targetURL.append("g:\"" + pGroupId + "\"+AND+");
        }
        if (!"".equals(pArtifactId)) {
            targetURL.append("a:\"" + pArtifactId + "\"+AND+");
        }
        if (pClassifier != null && !pClassifier.getValid().isEmpty()) {
            targetURL.append("c:\"");
            for (String currentClassifier : pClassifier.getValid()) {
                targetURL.append(currentClassifier);
            }
            targetURL.append("\"+AND+");
        }
        targetURL.append("&rows=" + this.getSearchLimit() + "&core=gav");
        String retVal = targetURL.toString();
        retVal = retVal.replace("+AND+&", "&");
        return retVal;
    }

    @Override
    public void setUserName(String pUserName) {
    }

    @Override
    public void setUserPassword(String pUserPassword) {
    }

    @Override
    public void setCredentials(String pUserName, String pUserPassword) {
    }

    public String getSearchURL() {
        return REPO_SEARCH_SERVICE_URL;
    }

    public String getRetrieveURL() {
        return REPO_RETRIEVE_URL;
    }

    int getSearchLimit() {
        return 100;
    }
}

