/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth.integrations.casc;

import java.util.List;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.matrixauth.AuthorizationType;
import org.jenkinsci.plugins.matrixauth.PermissionEntry;
import org.jenkinsci.plugins.matrixauth.integrations.casc.PermissionDefinition;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

@Restricted(value={NoExternalUse.class})
public class DefinitionEntry {
    private AuthorizationType type;
    private Child child;

    @DataBoundConstructor
    public DefinitionEntry() {
    }

    public DefinitionEntry(AuthorizationType type, Child child) {
        this.child = child;
        this.type = type;
    }

    @DataBoundSetter
    public void setUserOrGroup(Child child) {
        this.setNew(AuthorizationType.EITHER, child);
    }

    public Child getUserOrGroup() {
        return this.type == AuthorizationType.EITHER ? this.child : null;
    }

    @DataBoundSetter
    public void setUser(Child child) {
        this.setNew(AuthorizationType.USER, child);
    }

    public Child getUser() {
        return this.type == AuthorizationType.USER ? this.child : null;
    }

    @DataBoundSetter
    public void setGroup(Child child) {
        this.setNew(AuthorizationType.GROUP, child);
    }

    private void setNew(AuthorizationType type, Child child) {
        if (this.type != null) {
            throw new IllegalStateException("Can only configure one of: 'user', 'group', 'userOrGroup', but attempted to redefine to '" + DefinitionEntry.authorizationTypeToKey(type) + "' with name '" + child.name + "' after '" + DefinitionEntry.authorizationTypeToKey(this.type) + "' was already set to '" + this.child.name + "'");
        }
        this.type = type;
        this.child = child;
    }

    public Child getGroup() {
        return this.type == AuthorizationType.GROUP ? this.child : null;
    }

    public Child child() {
        return this.child;
    }

    public PermissionEntry permissionEntry() {
        return new PermissionEntry(this.type, this.child.name);
    }

    private static String authorizationTypeToKey(AuthorizationType type) {
        if (type == null) {
            throw new NullPointerException("Received null 'type'");
        }
        if (type == AuthorizationType.USER) {
            return "user";
        }
        if (type == AuthorizationType.GROUP) {
            return "group";
        }
        if (type == AuthorizationType.EITHER) {
            return "userOrGroup";
        }
        throw new IllegalStateException("Unexpected 'type': " + String.valueOf((Object)type));
    }

    @Restricted(value={NoExternalUse.class})
    public static class Child {
        final List<PermissionDefinition> permissions;
        final String name;

        @DataBoundConstructor
        public Child(String name, List<PermissionDefinition> permissions) {
            this.name = name;
            this.permissions = permissions;
        }

        public List<PermissionDefinition> getPermissions() {
            return this.permissions.stream().sorted().collect(Collectors.toList());
        }

        public String getName() {
            return this.name;
        }
    }
}

