/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth.inheritance;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.security.Permission;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategy;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategyDescriptor;
import org.jenkinsci.plugins.matrixauth.inheritance.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.security.core.Authentication;

public class InheritGlobalStrategy
extends InheritanceStrategy {
    @DataBoundConstructor
    public InheritGlobalStrategy() {
    }

    @Override
    protected boolean hasPermission(@NonNull Authentication a, @NonNull Permission permission, ACL child, @CheckForNull ACL parent, ACL root) {
        if (a.equals((Object)ACL.SYSTEM2)) {
            return true;
        }
        if (InheritGlobalStrategy.isParentReadPermissionRequired() && parent != null && (Item.READ.equals((Object)permission) || Item.DISCOVER.equals((Object)permission))) {
            boolean grantedViaChild = child.hasPermission2(a, permission);
            boolean grantedGlobally = root.hasPermission2(a, permission);
            boolean grantedInParent = parent.hasPermission2(a, permission);
            return (grantedViaChild || grantedGlobally) && grantedInParent;
        }
        return child.hasPermission2(a, permission) || root.hasPermission2(a, permission);
    }

    @Symbol(value={"inheritingGlobal"})
    @Extension
    public static class DescriptorImpl
    extends InheritanceStrategyDescriptor {
        @Override
        public boolean isApplicable(Class<?> clazz) {
            return true;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.InheritGlobalStrategy_DisplayName();
        }
    }
}

